/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.debug.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.ScriptModelHelper;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.debug.ui.launchConfigurations.MainLaunchConfigurationTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.xquery.core.model.ast.XQueryFunctionDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.set.internal.core.SETProjectConfig;
import org.eclipse.wst.xquery.set.internal.core.SETProjectConfigUtil;
import org.eclipse.wst.xquery.set.internal.debug.ui.launchConfigurations.SocketSelectionBlock;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerManager;
import org.eclipse.wst.xquery.set.internal.ui.SETEditProjectConfigDialog;

public class SETMainLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    private SocketSelectionBlock fSocketBlock;
    private Button fClearCollectionsCheckButton;
    private Button fIndentCheckButton;
    private Text fScriptText;
    private Button fHandlerFunctionButton;
    private Button fPublicResourceButton;
    private SETProjectConfig fConfig;

    public SETMainLaunchConfigurationTab(String mode) {
        super(mode);
    }

    protected boolean breakOnFirstLinePrefEnabled(PreferencesLookupDelegate delegate) {
        return false;
    }

    protected boolean dbpgLoggingPrefEnabled(PreferencesLookupDelegate delegate) {
        return false;
    }

    protected String getNatureID() {
        return "org.eclipse.wst.xquery.set.core.nature";
    }

    protected boolean validate() {
        return super.validate() && this.validateSocket();
    }

    protected boolean validateProject() {
        if (!super.validateProject()) {
            this.setErrorMessage("Select a valid Sausalito project");
            return false;
        }
        if (ServerManager.getInstance().isProjectStarted(this.getProject().getProject())) {
            this.setErrorMessage("The Project \"" + this.getProjectName() + "\" is already started");
            return false;
        }
        return true;
    }

    protected boolean validateScript() {
        String startPage = this.getScriptName();
        IProject project = this.getProject().getProject();
        if (project.getFile("public/" + startPage).exists()) {
            this.setErrorMessage(null);
            return true;
        }
        Path path = new Path(startPage);
        if (path.segmentCount() != 2) {
            this.setErrorMessage("Invalid start page. Use either a resource in the \"public\" directory or the format: /handler_module/function");
            return false;
        }
        IFolder folder = project.getFolder("handlers");
        if (!folder.isAccessible()) {
            this.setErrorMessage("The \"handlers\" directory is not accessible");
            return false;
        }
        String handlerName = path.segment(0);
        ISourceModule module = DLTKCore.createSourceModuleFrom((IFile)folder.getFile(String.valueOf(handlerName) + ".xq"));
        if (module == null || !module.exists()) {
            this.setErrorMessage("Could not find the '" + handlerName + ".xq' module in the \"" + "handlers" + "\" directory folder");
            return false;
        }
        ModuleDeclaration modDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (!(modDecl instanceof XQueryLibraryModule)) {
            this.setErrorMessage("The start page must point to a valid XQuery library module");
            return false;
        }
        String functionName = path.segment(1);
        XQueryLibraryModule libMod = (XQueryLibraryModule)modDecl;
        String prefix = libMod.getNamespacePrefix();
        XQueryFunctionDecl method = libMod.getFunction(String.valueOf(prefix) + ":" + functionName);
        if (method == null) {
            this.setErrorMessage("No function '" + functionName + "' is defined in the '" + handlerName + ".xq' handler module");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean validateSocket() {
        String host = this.getHost();
        int port = this.getPort();
        if (!ServerManager.getInstance().isSocketFree(host, port)) {
            this.setErrorMessage("The socket " + host + ":" + port + " is already used");
            return false;
        }
        return true;
    }

    protected boolean validateProject(IScriptProject project) {
        boolean result = true;
        try {
            result = project.getProject().hasNature("org.eclipse.wst.xquery.set.core.nature");
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result && super.validateProject(project);
    }

    protected IScriptProject chooseProject() {
        ScriptUILabelProvider labelProvider = DLTKUILanguageManager.createLabelProvider((String)this.getNatureID());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_title);
        dialog.setMessage(DLTKLaunchConfigurationsMessages.mainTab_chooseProject_message);
        try {
            IScriptProject[] xqdtProjects = ScriptModelHelper.getOpenedScriptProjects((IScriptModel)DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()), (String)this.getNatureID());
            ArrayList<IScriptProject> sausaProjects = new ArrayList<IScriptProject>();
            int i = 0;
            while (i < xqdtProjects.length) {
                try {
                    if (xqdtProjects[i].getProject().hasNature("org.eclipse.wst.xquery.set.core.nature")) {
                        sausaProjects.add(xqdtProjects[i]);
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            Object[] projects = sausaProjects.toArray(new IScriptProject[sausaProjects.size()]);
            dialog.setElements(projects);
        }
        catch (ModelException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        IScriptProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IScriptProject)dialog.getFirstResult();
        }
        return null;
    }

    public Image getImage() {
        return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.module_obj.gif");
    }

    protected void doCreateControl(Composite composite) {
        this.createMainModuleEditor(composite, "Start page");
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 5);
        this.doCreateControl(comp);
        this.createVerticalSpacer(comp, 5);
        this.createSocketBlock(comp);
        this.createVerticalSpacer(comp, 5);
        this.createOptionsGroup(comp);
        this.createVerticalSpacer(comp, 5);
        this.createDebugOptionsGroup(comp);
        Dialog.applyDialogFont((Control)comp);
    }

    protected void createMainModuleEditor(Composite parent, String text) {
        Group scriptGroup = new Group(parent, 0);
        scriptGroup.setText(text);
        GridData gd = new GridData(768);
        scriptGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        scriptGroup.setLayout((Layout)layout);
        String labelText = "Select either an existing resource from the \"public\" directory or handler function:";
        SWTFactory.createLabel((Composite)scriptGroup, (String)labelText, (int)2);
        this.fScriptText = new Text((Composite)scriptGroup, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fScriptText.setLayoutData((Object)gd);
        this.fScriptText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SETMainLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite buttonComp = new Composite((Composite)scriptGroup, 0);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComp.setLayout((Layout)layout);
        this.fHandlerFunctionButton = this.createPushButton(buttonComp, "Handler function...", null);
        this.fHandlerFunctionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SETMainLaunchConfigurationTab.this.handleHandlerFunctionButtonSelected();
            }
        });
        this.fPublicResourceButton = this.createPushButton(buttonComp, "Public resource...", null);
        this.fPublicResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SETMainLaunchConfigurationTab.this.handlePublicResourceButtonSelected();
            }
        });
    }

    protected void createSocketBlock(Composite comp) {
        this.fSocketBlock = new SocketSelectionBlock(comp);
        this.fSocketBlock.addSelectionListener((SelectionListener)this.getWidgetListener());
    }

    protected void createOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Options");
        GridData gd = new GridData(768);
        if (parent.getLayout() instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.createOptions((Composite)group);
    }

    protected void createOptions(Composite group) {
        this.addClearCollectionsButton(group);
        this.addIndentButton(group);
    }

    private void addClearCollectionsButton(Composite group) {
        this.fClearCollectionsCheckButton = this.createCheckButton(group, "Clear collection data");
        this.fClearCollectionsCheckButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.createVerticalSpacer(group, 1);
    }

    private void addIndentButton(Composite group) {
        this.fIndentCheckButton = this.createCheckButton(group, "Indent results");
        this.fIndentCheckButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.createVerticalSpacer(group, 1);
    }

    protected void setEnableScriptField(boolean enabled) {
        this.fScriptText.setEnabled(enabled);
        this.fHandlerFunctionButton.setEnabled(enabled && this.isValidProject());
    }

    protected void updateMainModuleFromConfig(ILaunchConfiguration config) {
        this.fScriptText.setText(this.getMainModuleName(config));
    }

    protected String getScriptName() {
        return this.fScriptText.getText().trim();
    }

    protected void setScriptName(String value) {
        this.fScriptText.setText(value);
    }

    private String getMainModuleName(ILaunchConfiguration config) {
        return LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"mainScript", (String)"");
    }

    private String getProjectName(ILaunchConfiguration config) {
        return LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"project", (String)"");
    }

    protected void handleHandlerFunctionButtonSelected() {
        String startPage = SETEditProjectConfigDialog.getHandlerFunctionStartPage((IProject)this.getProject().getProject(), (Shell)this.getShell());
        this.fScriptText.setText(startPage);
    }

    protected void handlePublicResourceButtonSelected() {
        String startPage = SETEditProjectConfigDialog.getPublicResourceStartPage((IProject)this.getProject().getProject(), (Shell)this.getShell());
        this.fScriptText.setText(startPage);
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("xqdt_set_host", this.fSocketBlock.fIpCombo.getText());
        config.setAttribute("xqdt_set_port", Integer.parseInt(this.fSocketBlock.fPortSpinner.getText()));
        config.setAttribute("xqdt_set_indent", this.fIndentCheckButton.getSelection());
        config.setAttribute("xqdt_set_cear_collections", this.fClearCollectionsCheckButton.getSelection());
        super.doPerformApply(config);
        if (this.getProject() != null && this.getProject().getProject().isAccessible()) {
            this.fConfig = SETProjectConfigUtil.readProjectConfig((IProject)this.getProject().getProject());
            String startPage = this.getScriptName();
            if (this.fConfig != null && startPage.length() != 0 && !startPage.equals(this.fConfig.getStartPage())) {
                this.fConfig.setStartPage(startPage);
                SETProjectConfigUtil.writeProjectConfig((IProject)this.getProject().getProject(), (SETProjectConfig)this.fConfig);
            }
        }
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        super.doInitializeForm(config);
        IScriptProject project = this.getProject();
        if (project.exists() && project.getProject().isAccessible()) {
            this.fConfig = SETProjectConfigUtil.readProjectConfig((IProject)project.getProject());
        }
        this.fScriptText.setText(this.getProjectStartPage());
        this.fSocketBlock.fIpCombo.setText(this.getHost(config));
        this.fSocketBlock.fPortSpinner.setSelection(this.getPort(config));
        this.fIndentCheckButton.setSelection(this.getIndent(config));
        this.fClearCollectionsCheckButton.setSelection(this.getClearCollections(config));
    }

    private String getHost(ILaunchConfiguration config) {
        return LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"xqdt_set_host", (String)"127.0.0.1");
    }

    private String getHost() {
        return this.fSocketBlock.fIpCombo.getText();
    }

    private int getPort(ILaunchConfiguration config) {
        int value = 8080;
        try {
            if (config != null) {
                value = config.getAttribute("xqdt_set_port", 8080);
            }
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log((Throwable)e);
        }
        return value;
    }

    private int getPort() {
        return Integer.parseInt(this.fSocketBlock.fPortSpinner.getText());
    }

    private boolean getIndent(ILaunchConfiguration config) {
        return LaunchConfigurationUtils.getBoolean((ILaunchConfiguration)config, (String)"xqdt_set_indent", (boolean)false);
    }

    private boolean getClearCollections(ILaunchConfiguration config) {
        return LaunchConfigurationUtils.getBoolean((ILaunchConfiguration)config, (String)"xqdt_set_cear_collections", (boolean)false);
    }

    protected void setDefaults(ILaunchConfigurationWorkingCopy configuration, IModelElement element) {
        super.setDefaults(configuration, element);
        String startPage = this.getProjectStartPage();
        configuration.setAttribute("mainScript", startPage);
    }

    protected void projectChanged() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        if (project.isAccessible()) {
            this.fConfig = SETProjectConfigUtil.readProjectConfig((IProject)project);
            this.setScriptName(this.getProjectStartPage());
        }
    }

    private String getProjectStartPage() {
        if (this.fConfig == null) {
            return "";
        }
        return this.fConfig.getStartPage();
    }
}

