/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.deploy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.wst.xquery.set.internal.launching.deploy.DeployInfo;
import org.eclipse.wst.xquery.set.internal.launching.deploy.Deployer;

public class DeployManager {
    private static DeployManager instance;
    private Map<IScriptProject, Deployer> fProjectDeployers = new HashMap<IScriptProject, Deployer>();

    private DeployManager() {
    }

    public static DeployManager getInstance() {
        if (instance == null) {
            instance = new DeployManager();
        }
        return instance;
    }

    public Deployer getDeployer(DeployInfo info, boolean useCache) {
        Deployer deployer = this.fProjectDeployers.get(info.getProject());
        if (deployer != null) {
            if (useCache) {
                deployer.setDeployInfo(info);
            } else {
                this.fProjectDeployers.remove(info.getProject());
            }
            deployer.initJobs();
        } else {
            deployer = new Deployer(info);
            if (useCache) {
                this.fProjectDeployers.put(info.getProject(), deployer);
            }
        }
        return deployer;
    }

    public DeployInfo getCachedDeployInfo(IScriptProject project) {
        Deployer deployer = this.fProjectDeployers.get(project);
        if (deployer != null) {
            return deployer.getDeployInfo();
        }
        return null;
    }
}

