/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xquery.set.debug.core.model.SETDebugTarget;
import org.eclipse.wst.xquery.set.internal.launching.SETLaunchConfigurationDelegate;
import org.eclipse.wst.xquery.set.internal.launching.server.IServerLaunchListener;
import org.eclipse.wst.xquery.set.internal.launching.server.Server;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerManager;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerNotStartedException;

public class ServerLaunchJob
extends Job {
    private List<IServerLaunchListener> fListeners = new ArrayList<IServerLaunchListener>(1);
    private Server fServer;
    private ILaunch fLaunch;

    public ServerLaunchJob(ILaunch launch, Server server) {
        super("Launch Web Server: " + server.getSocketString());
        this.fServer = server;
        this.fLaunch = launch;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        Process p;
        IProject project;
        try {
            project = SETLaunchConfigurationDelegate.getLaunchProject(this.fLaunch);
        }
        catch (CoreException ce) {
            return new Status(4, "org.eclipse.wst.xquery.set.debug.core", "Could not retreive the project for this launch configuration", (Throwable)ce);
        }
        ServerManager sm = ServerManager.getInstance();
        Server s = sm.getProjectServer(project);
        if (sm.isProjectStarted(project)) {
            if (sm.isServerRunning(s)) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.fLaunch);
                return new Status(4, "org.eclipse.wst.xquery.set.debug.core", "It is not allowed to simultaneously run more instances of the same project (Project: " + project.getName() + ")");
            }
            sm.removeStartedProject(project);
        }
        if (sm.isServerRunning(s)) {
            return new Status(4, "org.eclipse.wst.xquery.set.debug.core", "An old server process is still running for this project (Project: " + project.getName() + ")");
        }
        if (!sm.isSocketFree(this.fServer.getHost(), this.fServer.getPort())) {
            Server srv = sm.getServer(this.fServer.getSocketString());
            if (sm.isServerRunning(srv)) {
                this.notifyListeners();
                return Status.CANCEL_STATUS;
            }
            sm.removeStartedServer(String.valueOf(this.fServer.getHost()) + ":" + this.fServer.getPort());
        }
        try {
            ILaunchConfigurationWorkingCopy config = this.fLaunch.getLaunchConfiguration().getWorkingCopy();
            config.setAttribute("xqdt_set_port", this.fServer.getPort());
            config.doSave();
        }
        catch (CoreException ce) {
            return new Status(4, "org.eclipse.wst.xquery.set.debug.core", "An exception occured while updating the project launch configuration for project: " + project.getName(), (Throwable)ce);
        }
        sm.addProjectServer(project, this.fServer);
        this.deleteOldServerPidFile(project);
        try {
            p = this.fServer.run();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            return new Status(4, "org.eclipse.wst.xquery.set.debug.core", "An exception occured while starting the server: " + this.fServer.getSocketString(), (Throwable)ce);
        }
        ServerManager.getInstance().addStartedServer(this.fServer.getSocketString(), project);
        final IProcess process = DebugPlugin.newProcess((ILaunch)this.fLaunch, (Process)p, (String)"Sausalito Development Web Server");
        IStreamsProxy proxy = process.getStreamsProxy();
        proxy.getErrorStreamMonitor().addListener((IStreamListener)this.fServer);
        SETDebugTarget target = new SETDebugTarget(this.fLaunch, process, project);
        this.fLaunch.addDebugTarget((IDebugTarget)target);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events.length > 0 && events[0].getKind() == 8 && events[0].getSource() == process) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        public void run() {
                            ServerManager.getInstance().stopServer(project);
                        }
                    });
                }
            }
        });
        if (!DebugPlugin.getDefault().getLaunchManager().isRegistered(this.fLaunch)) {
            DebugPlugin.getDefault().getLaunchManager().addLaunch(this.fLaunch);
        }
        long startTime = Calendar.getInstance().getTimeInMillis();
        try {
            Thread.sleep(250L);
            while (!this.fServer.isListening() && startTime + 10000L > Calendar.getInstance().getTimeInMillis()) {
                Thread.sleep(250L);
            }
            if (!this.fServer.isListening()) {
                return this.cancelJob((IDebugTarget)target, process, false, null);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ServerNotStartedException snse) {
            boolean notify = snse.getErrorCode() == 1;
            return this.cancelJob((IDebugTarget)target, process, notify, snse);
        }
        return Status.OK_STATUS;
    }

    private IStatus cancelJob(IDebugTarget target, IProcess process, boolean notify, Throwable t) {
        ServerManager.getInstance().removeStartedServer(this.fServer.getSocketString());
        try {
            this.fLaunch.terminate();
            process.terminate();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        if (notify) {
            this.notifyListeners();
            return Status.CANCEL_STATUS;
        }
        return new Status(4, "org.eclipse.wst.xquery.set.debug.core", "An error ocured while starting the server.", t);
    }

    private void notifyListeners() {
        for (IServerLaunchListener listener : this.fListeners) {
            listener.fail(this);
        }
    }

    public void addServerLaunchListener(IServerLaunchListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeServerLaunchListener(IServerLaunchListener listener) {
        this.fListeners.remove(listener);
    }

    public Server getServer() {
        return this.fServer;
    }

    public void setServer(Server server) {
        this.fServer = server;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void deleteOldServerPidFile(IProject project) {
        File pidFile = new File(project.getLocation().toOSString(), "/test/log/httpd.pid");
        if (!pidFile.exists()) {
            return;
        }
        pidFile.delete();
    }
}

