/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.xquery.set.internal.launching.SETLaunchConfigurationDelegate;
import org.eclipse.wst.xquery.set.internal.launching.server.IServerLaunchListener;
import org.eclipse.wst.xquery.set.internal.launching.server.Server;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerLaunchJob;

public class ServerManager {
    private static ServerManager instance;
    private Map<String, IProject> fStartedProjects = new HashMap<String, IProject>();
    private Map<IProject, Server> fProjectServers = new HashMap<IProject, Server>();
    private List<IServerLaunchListener> fServerLaunchListeners = new ArrayList<IServerLaunchListener>();

    private ServerManager() {
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void addServerLaunchListener(IServerLaunchListener listener) {
        if (this.fServerLaunchListeners.contains(listener)) {
            return;
        }
        this.fServerLaunchListeners.add(listener);
    }

    public void removeServerLaunchListener(IJobChangeListener listener) {
        this.fServerLaunchListeners.remove(listener);
    }

    public synchronized void addStartedServer(String socket, IProject project) {
        this.fStartedProjects.put(socket, project);
    }

    public synchronized void removeStartedServer(String socket) {
        this.fStartedProjects.remove(socket);
    }

    public ServerLaunchJob createServerJob(ILaunch launch) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        IProject project = SETLaunchConfigurationDelegate.getLaunchProject(launch);
        String host = config.getAttribute("xqdt_set_host", "127.0.0.1");
        int port = config.getAttribute("xqdt_set_port", 8080);
        boolean indent = config.getAttribute("xqdt_set_indent", true);
        boolean clear = config.getAttribute("xqdt_set_cear_collections", false);
        Server server = new Server(project, host, port, indent, clear);
        ServerLaunchJob job = new ServerLaunchJob(launch, server);
        for (IServerLaunchListener listener : this.fServerLaunchListeners) {
            job.addServerLaunchListener(listener);
        }
        return job;
    }

    public void stopServer(final IProject project) {
        final Server server = this.getProjectServer(project);
        final String socket = server.getSocketString();
        Job job = new Job("Stopping server: " + socket){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void handleKillProcessError(Process p, List<String> commandList) throws CoreException {
                StringBuilder sb = new StringBuilder();
                for (String s : commandList) {
                    sb.append(String.valueOf(s) + " ");
                }
                StringBuilder sbe = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        sbe.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException ioe) {
                    sbe.append("Could not read the procees error stream: " + ioe.getMessage());
                }
                String message = "Terminate command did not exit properly (" + p.exitValue() + "): " + sb.toString() + "\nError: " + sbe.toString();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.set.debug.core", message));
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    public Server getServer(String socket) {
        IProject p = this.fStartedProjects.get(socket);
        if (p == null) {
            return null;
        }
        return this.fProjectServers.get(p);
    }

    public boolean isSocketFree(String host, int port) {
        return !this.fStartedProjects.containsKey(String.valueOf(host) + ":" + port);
    }

    public boolean isProjectStarted(IProject project) {
        return this.fStartedProjects.containsValue(project);
    }

    public void removeStartedProject(IProject project) {
        if (this.isProjectStarted(project)) {
            Iterator<Map.Entry<String, IProject>> it = this.fStartedProjects.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IProject> e = it.next();
                if (!e.getValue().equals((Object)project)) continue;
                it.remove();
                break;
            }
        }
    }

    public static int getServerPid(IProject project) throws DebugException {
        try {
            File pidFile = new File(project.getLocation().toOSString(), "/test/log/httpd.pid");
            if (!pidFile.exists()) {
                throw new FileNotFoundException();
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(pidFile)));
            String pidStr = br.readLine().trim();
            int pid = Integer.parseInt(pidStr);
            return pid;
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.wst.xquery.set.debug.core", "An exception occured while retrieving the web server process ID.", (Throwable)e));
        }
    }

    public Server getProjectServer(IProject project) {
        return this.fProjectServers.get(project);
    }

    public void addProjectServer(IProject project, Server server) {
        this.fProjectServers.put(project, server);
    }

    public boolean isServerRunning(Server server) {
        if (server == null) {
            return false;
        }
        Process p = server.getProcess();
        if (p == null) {
            return false;
        }
        try {
            p.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        return false;
    }
}

