/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.variables;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.osgi.framework.Bundle;

public class CoreSdkLocationResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        String os = Platform.getOS();
        if (os.equals("win32")) {
            Bundle[] bundles = Platform.getBundles((String)"org.eclipse.wst.xquery.set.coresdk.win32", null);
            if (bundles == null || bundles.length == 0) {
                this.throwException("No CoreSDK plugin fragment was found");
            }
            Bundle bundle = bundles[0];
            URL coreSdkURL = bundle.getEntry("/coresdk");
            try {
                String coreSdkHome = new Path(FileLocator.toFileURL((URL)coreSdkURL).getFile()).toOSString();
                return coreSdkHome;
            }
            catch (IOException iOException) {
                this.throwException("Error while resolving the Sausalito CoreSDK installation location in the bundle: org.eclipse.wst.xquery.set.coresdk.win32");
            }
        } else if (os.equals("macosx") || os.equals("linux")) {
            File dir = new File("/opt/sausalito");
            if (dir.isDirectory()) {
                return dir.toString();
            }
            this.throwException("Could not find a Sausalito CoreSDK installation at location: /opt/sausalito");
        }
        this.throwException("No default interpreters are supported on this platform: " + os);
        return "";
    }

    private void throwException(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.set.launching", message));
    }
}

