/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.actions;

import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETImportDataJob;

public class SETImportDataAction
implements IObjectActionDelegate {
    private IProject fProject;
    private Shell fCurrentShell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fCurrentShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.fProject == null) {
            ErrorDialog.openError((Shell)this.fCurrentShell, (String)"Import Data Error", (String)"An error occured while initiating the data import", (IStatus)new Status(4, "org.eclipse.wst.xquery.org.set.ui", "The Sausalito project could not be determined"));
            return;
        }
        MessageConsole console = new MessageConsole("Sausalito Command", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        this.fCurrentShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                }
                catch (PartInitException partInitException) {}
            }
        });
        SETImportDataJob job = new SETImportDataJob(this.fProject, (OutputStream)console.newMessageStream());
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).getFirstElement() instanceof IProject) {
            this.fProject = (IProject)ss.getFirstElement();
        }
    }
}

