/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xquery.set.internal.launching.deploy.DeployInfo;
import org.eclipse.wst.xquery.set.internal.launching.deploy.DeployManager;
import org.eclipse.wst.xquery.set.internal.launching.deploy.Deployer;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETDeployDataJob;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETDeployProjectJob;
import org.eclipse.wst.xquery.set.internal.ui.util.SETPluginImages;
import org.eclipse.wst.xquery.set.internal.ui.wizards.SETDeployProjectWizardPage;

public class SETDeployProjectWizard
extends Wizard {
    private IScriptProject fProject;
    private SETDeployProjectWizardPage fDeployPage;

    public SETDeployProjectWizard(IScriptProject project) {
        this.setDefaultPageImageDescriptor(SETPluginImages.DESC_WIZBAN_DEPLOY_PROJECT);
        this.fProject = project;
    }

    public void addPages() {
        this.fDeployPage = new SETDeployProjectWizardPage(this.fProject);
        this.addPage((IWizardPage)this.fDeployPage);
        this.setWindowTitle("Deploy Sausalito Project");
    }

    public boolean performFinish() {
        final DeployInfo info = this.fDeployPage.getDeployInfo();
        boolean useCache = this.fDeployPage.cacheCredentials();
        Deployer deployer = DeployManager.getInstance().getDeployer(info, useCache);
        deployer.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Job job = event.getJob();
                IStatus status = job.getResult();
                if (job instanceof SETDeployProjectJob) {
                    if (status.isOK()) {
                        this.displayMessageBox("The project \"" + info.getProject().getElementName() + "\" was succesfully deployed as application \"" + info.getApplicationName() + "\"", true);
                    }
                } else if (job instanceof SETDeployDataJob && status.isOK()) {
                    this.displayMessageBox("The data for project \"" + info.getProject().getElementName() + "\" was succesfully deployed into the application \"" + info.getApplicationName() + "\"", true);
                }
            }

            private void displayMessageBox(final String message, final boolean isSuccess) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageBox mb = new MessageBox(new Shell(Display.getDefault().getActiveShell()), (isSuccess ? 2 : 1) | 0x20);
                        mb.setMessage(message);
                        mb.open();
                    }
                });
            }
        });
        deployer.execute();
        return true;
    }
}

