/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericResourcePool<K, V> {
    private Map<K, List<PoolItem>> pools = Collections.synchronizedMap(new HashMap());
    private int limit = Integer.MAX_VALUE;

    public GenericResourcePool(int limit) {
        this.limit = limit;
    }

    public GenericResourcePool() {
        this(Integer.MAX_VALUE);
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be a non-zero positive value");
        }
        this.limit = limit;
    }

    public boolean isEmpty(K key) {
        List<PoolItem> list = this.findList(this.pools, key);
        return list == null || list.isEmpty();
    }

    public void put(K key, V resource, long expireTimeMillis) {
        this.addItemToList(key, resource, expireTimeMillis);
    }

    public void put(K key, V obj) {
        this.put(key, obj, -1L);
    }

    public V get(K key) {
        return this.getItemFromList(key);
    }

    public long size(K key) {
        List<PoolItem> list = this.findList(this.pools, key);
        return list == null ? 0 : list.size();
    }

    protected void itemExpired(PoolItem item) {
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getItemFromList(K key) {
        PoolItem item;
        List<PoolItem> list = this.findList(this.pools, key);
        long now = this.getCurrentTime();
        if (list == null) {
            return null;
        }
        while (true) {
            item = null;
            List<PoolItem> list2 = list;
            synchronized (list2) {
                block7: {
                    if (!list.isEmpty()) break block7;
                    return null;
                }
                item = list.remove(0);
            }
            if (item == null) {
                return null;
            }
            if (!item.hasExpired(now)) break;
            this.itemExpired(item);
        }
        return item.getValue();
    }

    private void addItemToList(K key, V resource, long expireTimeMillis) {
        List<PoolItem> list = this.findOrCreateList(this.pools, key);
        if (list.size() >= this.limit) {
            return;
        }
        PoolItem item = new PoolItem(resource, expireTimeMillis);
        if (!item.hasExpired(this.getCurrentTime())) {
            list.add(item);
        }
    }

    private List<PoolItem> findList(Map<K, List<PoolItem>> pools, K key) {
        return pools.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PoolItem> findOrCreateList(Map<K, List<PoolItem>> pools, K key) {
        List<PoolItem> list;
        Map<K, List<PoolItem>> map = pools;
        synchronized (map) {
            list = this.findList(pools, key);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                pools.put(key, list);
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PoolItem {
        private V item;
        private long expireTime;

        public PoolItem(V item, long expireTime) {
            this.item = item;
            this.expireTime = expireTime;
        }

        public V getValue() {
            return this.item;
        }

        public boolean hasExpired(long currTime) {
            return this.expireTime != -1L && currTime >= this.expireTime;
        }
    }
}

