/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.wst.xquery.marklogic.xcc.ContentFactory;
import org.eclipse.wst.xquery.marklogic.xcc.types.AtomicType;
import org.eclipse.wst.xquery.marklogic.xcc.types.Duration;
import org.eclipse.wst.xquery.marklogic.xcc.types.NodeType;
import org.eclipse.wst.xquery.marklogic.xcc.types.SequenceType;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XName;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSBoolean;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSDate;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSDateTime;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSDuration;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSInteger;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSString;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSTime;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmAtomic;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmBinary;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmDuration;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmElement;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmItem;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmNode;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmSequence;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmText;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmValue;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmVariable;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.BinaryImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.ElementImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.SequenceImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.TextImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsAnyUriImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsBase64BinaryImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsBooleanImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsDateImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsDateTimeImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsDayTimeDurationImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsDecimalImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsDoubleImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsDurationImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsFloatImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsGDayImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsGMonthDayImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsGMonthImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsGYearImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsGYearMonthImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsHexBinaryImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsIntegerImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsQNameImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsStringImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsTimeImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsUntypedAtomicImpl;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.XsYearMonthDurationImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueFactory {
    private ValueFactory() {
    }

    public static XdmValue newValue(ValueType valueType, Object value) {
        if (valueType instanceof SequenceType) {
            return ValueFactory.newSequenceValue(value);
        }
        if (valueType instanceof NodeType) {
            return ValueFactory.newNodeValue(valueType, value);
        }
        if (valueType instanceof AtomicType) {
            return ValueFactory.newAtomicValue(valueType, value);
        }
        throw new IllegalArgumentException("Unrecognized ValueType: " + valueType);
    }

    public static XdmElement newElement(Object value) {
        if (value instanceof String) {
            return new ElementImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new ElementImpl((InputStream)value);
        }
        if (value instanceof Element) {
            byte[] bytes = ContentFactory.bytesFromW3cNode((Element)value);
            return new ElementImpl(new ByteArrayInputStream(bytes));
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Element or InputStream value required to construct " + ValueType.ELEMENT);
    }

    public static XdmText newTextNode(Object value) {
        if (value instanceof String) {
            return new TextImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new TextImpl((InputStream)value);
        }
        if (value instanceof Text) {
            Text text = (Text)value;
            return new TextImpl(text.getNodeValue());
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Text or InputStream value required to construct " + ValueType.ELEMENT);
    }

    public static XdmBinary newBinaryNode(Object value) {
        if (value instanceof String) {
            byte[] bytes = null;
            try {
                bytes = ((String)value).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = ((String)value).getBytes();
            }
            return new BinaryImpl(new ByteArrayInputStream(bytes), true);
        }
        if (value instanceof byte[]) {
            return new BinaryImpl(new ByteArrayInputStream((byte[])value), true);
        }
        if (value instanceof InputStream) {
            return new BinaryImpl((InputStream)value, true);
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Text or InputStream value required to construct " + ValueType.ELEMENT);
    }

    public static XSString newXSString(String value) {
        return (XSString)ValueFactory.newValue(ValueType.XS_STRING, value);
    }

    public static XSInteger newXSInteger(long value) {
        return (XSInteger)ValueFactory.newValue(ValueType.XS_INTEGER, new Long(value));
    }

    public static XSInteger newXSInteger(BigInteger value) {
        return (XSInteger)ValueFactory.newValue(ValueType.XS_INTEGER, value);
    }

    public static XSBoolean newXSBoolean(boolean value) {
        return new XsBooleanImpl(value);
    }

    public static XSDateTime newXSDateTime(String value, TimeZone timeZone, Locale locale) {
        return new XsDateTimeImpl(value, timeZone, locale);
    }

    public static XSDate newXSDate(String value, TimeZone timeZone, Locale locale) {
        return new XsDateImpl(value, timeZone, locale);
    }

    public static XSTime newXSTime(String value, TimeZone timeZone, Locale locale) {
        return new XsTimeImpl(value, timeZone, locale);
    }

    public static XSDuration newXSDuration(String value) {
        return new XsDurationImpl(value);
    }

    public static XSDuration newXSDuration(XdmDuration duration) {
        return ValueFactory.newXSDuration(duration.toString());
    }

    public static XdmDuration newDuration(String serializedString) {
        return new Duration(serializedString);
    }

    public static XdmSequence<XdmItem> newSequence(XdmValue[] values) {
        return new SequenceImpl(values);
    }

    public static XdmVariable newVariable(XName name, XdmValue value) {
        return new XdmVar(name, value);
    }

    private static XdmSequence<XdmItem> newSequenceValue(Object values) {
        if (!(values instanceof XdmValue[])) {
            throw new IllegalArgumentException("Value must be array of XdmValue");
        }
        return ValueFactory.newSequence((XdmValue[])values);
    }

    private static XdmNode newNodeValue(ValueType valueType, Object value) {
        if (valueType == ValueType.ELEMENT) {
            return ValueFactory.newElement(value);
        }
        if (valueType == ValueType.NODE) {
            return ValueFactory.newElement(value);
        }
        if (valueType == ValueType.TEXT) {
            return ValueFactory.newTextNode(value);
        }
        if (valueType == ValueType.BINARY) {
            return ValueFactory.newBinaryNode(value);
        }
        throw new InternalError("Unrecognized valueType: " + valueType);
    }

    private static XdmAtomic newAtomicValue(ValueType valueType, Object value) {
        if (valueType == ValueType.XS_STRING) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsStringImpl((String)value);
        }
        if (valueType == ValueType.XS_INTEGER) {
            return new XsIntegerImpl(value);
        }
        if (valueType == ValueType.XS_DECIMAL) {
            return new XsDecimalImpl(value);
        }
        if (valueType == ValueType.XS_DOUBLE) {
            return new XsDoubleImpl(value);
        }
        if (valueType == ValueType.XS_FLOAT) {
            return new XsFloatImpl(value);
        }
        if (valueType == ValueType.XS_BOOLEAN) {
            if (value instanceof Boolean) {
                return new XsBooleanImpl((Boolean)value);
            }
            if (value instanceof String) {
                return new XsBooleanImpl((String)value);
            }
            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + "), must be Boolean or String");
        }
        if (valueType == ValueType.XS_ANY_URI) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsAnyUriImpl((String)value);
        }
        if (valueType == ValueType.XS_QNAME) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsQNameImpl((String)value);
        }
        if (valueType == ValueType.XS_UNTYPED_ATOMIC) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsUntypedAtomicImpl((String)value);
        }
        if (valueType == ValueType.XS_DURATION) {
            if (value instanceof XdmDuration) {
                return new XsDurationImpl(value.toString());
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsDurationImpl((String)value);
        }
        if (valueType == ValueType.XS_DAY_TIME_DURATION) {
            if (value instanceof XdmDuration) {
                return new XsDayTimeDurationImpl(value.toString());
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsDayTimeDurationImpl((String)value);
        }
        if (valueType == ValueType.XS_YEAR_MONTH_DURATION) {
            if (value instanceof XdmDuration) {
                return new XsYearMonthDurationImpl(value.toString());
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsYearMonthDurationImpl((String)value);
        }
        if (valueType == ValueType.XS_DATE_TIME) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsDateTimeImpl((String)value, TimeZone.getDefault(), Locale.getDefault());
        }
        if (valueType == ValueType.XS_DATE) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsDateImpl((String)value, TimeZone.getDefault(), Locale.getDefault());
        }
        if (valueType == ValueType.XS_TIME) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsTimeImpl((String)value, TimeZone.getDefault(), Locale.getDefault());
        }
        if (valueType == ValueType.XS_GDAY) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGDayImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GMONTH) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGMonthImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GMONTH_DAY) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGMonthDayImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GYEAR) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGYearImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GYEAR_MONTH) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGYearMonthImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_HEX_BINARY) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsHexBinaryImpl((String)value);
        }
        if (valueType == ValueType.XS_BASE64_BINARY) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsBase64BinaryImpl((String)value);
        }
        throw new IllegalStateException("Unhandled type: " + valueType);
    }

    private static void assertStringArg(Object value, ValueType valueType) {
        if (value instanceof String) {
            return;
        }
        throw new IllegalArgumentException("String value required to construct " + valueType);
    }

    private static class XdmVar
    implements XdmVariable {
        private final XName name;
        private final XdmValue value;

        public XdmVar(XName name, XdmValue value) {
            this.name = name;
            this.value = value;
        }

        public XName getName() {
            return this.name;
        }

        public XdmValue getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XdmVariable) {
                XdmVariable var = (XdmVariable)obj;
                return this.name.equals(var.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

