/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.io.Base64;
import org.eclipse.wst.xquery.marklogic.io.IOHelper;
import org.eclipse.wst.xquery.marklogic.xcc.ContentSource;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.UserCredentials;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SessionImpl;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSourceImpl
implements ContentSource {
    private static final String DEFAULT_LOGGER_NAME = "org.eclipse.wst.xquery.marklogic.xcc";
    private static final String XCC_LOGGING_CONFIG_FILE = "xcc.logging.properties";
    private static final String SYSTEM_LOGGING_CONFIG_CLASS = "java.util.logging.config.class";
    private static final String SYSTEM_LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private final ConnectionProvider connectionProvider;
    private final String user;
    private final String password;
    private final String contentBase;
    private Logger logger = ContentSourceImpl.newDefaultLogger();
    private static Random random = new Random();

    private static Logger newDefaultLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(DEFAULT_LOGGER_NAME);
        if (logger != null) {
            return logger;
        }
        if (System.getProperty(SYSTEM_LOGGING_CONFIG_CLASS) != null || System.getProperty(SYSTEM_LOGGING_CONFIG_FILE) != null) {
            return Logger.getLogger(DEFAULT_LOGGER_NAME);
        }
        return ContentSourceImpl.customizedLogger(logManager);
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, String user, String password, String contentBase) {
        this.connectionProvider = connectionProvider;
        this.user = user;
        this.password = password;
        String cbName = contentBase;
        if (cbName != null && (cbName = cbName.trim()).length() == 0) {
            cbName = null;
        }
        this.contentBase = cbName;
    }

    @Override
    public Session newSession() {
        if (this.user == null || this.password == null) {
            throw new IllegalStateException("No default user/password configured");
        }
        return this.newSession(this.user, this.password);
    }

    @Override
    public Session newSession(String userName, String password) {
        return this.newSession(userName, password, null);
    }

    @Override
    public Session newSession(String user, String password, String contentBaseArg) {
        if (user == null || password == null) {
            throw new IllegalStateException("Invalid authentication credentials");
        }
        String contentBase = contentBaseArg == null ? this.contentBase : contentBaseArg;
        return new SessionImpl(this, this.connectionProvider, new Credentials(user, password), contentBase);
    }

    @Override
    public Session newSession(String databaseId) {
        return this.newSession(this.user, this.password, databaseId);
    }

    @Override
    public Logger getDefaultLogger() {
        return this.logger;
    }

    @Override
    public void setDefaultLogger(Logger logger) {
        this.logger = logger;
    }

    public String toString() {
        return "user=" + (this.user == null ? "{none}" : this.user) + ", cb=" + (this.contentBase == null ? "{none}" : this.contentBase) + " [provider: " + this.connectionProvider.toString() + "]";
    }

    private static Logger customizedLogger(LogManager logManager) {
        Properties props = ContentSourceImpl.loadPropertiesFromResource(XCC_LOGGING_CONFIG_FILE);
        Logger logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
        List<Handler> handlers = ContentSourceImpl.getLoggerHandlers(logger, logManager, props);
        Iterator<Handler> it = handlers.iterator();
        while (it.hasNext()) {
            logger.addHandler(it.next());
        }
        boolean useParentHandlers = ContentSourceImpl.getUseParentHandlersFlag(logger, logManager, props);
        logger.setUseParentHandlers(useParentHandlers);
        logManager.addLogger(logger);
        return logger;
    }

    private static Properties loadPropertiesFromResource(String path) {
        Properties props = new Properties();
        InputStream is = ContentSource.class.getResourceAsStream(path);
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    private static List<Handler> getLoggerHandlers(Logger logger, LogManager logManager, Properties props) {
        String propName = String.valueOf(logger.getName()) + ".handlers";
        String handlerPropVal = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (handlerPropVal == null) {
            return new ArrayList<Handler>(0);
        }
        String[] handlerClassNames = handlerPropVal.split("\\\\s*,?\\\\s*");
        ArrayList<Handler> handlers = new ArrayList<Handler>(handlerClassNames.length);
        Level level = ContentSourceImpl.getLoggerLevel(logger, logManager, props);
        if (level != null) {
            logger.setLevel(level);
        }
        int i = 0;
        while (i < handlerClassNames.length) {
            try {
                Class<Handler> handlerClass = Class.forName(handlerClassNames[i]).asSubclass(Handler.class);
                Handler handler = handlerClass.newInstance();
                Formatter formatter = ContentSourceImpl.getFormatter(handler, logManager, props);
                handlers.add(handler);
                if (formatter != null) {
                    handler.setFormatter(formatter);
                }
                if (level != null) {
                    handler.setLevel(level);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return handlers;
    }

    private static Formatter getFormatter(Handler handler, LogManager logManager, Properties props) {
        String propName = String.valueOf(handler.getClass().getName()) + ".formatter";
        String formatterClassName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            Class<Formatter> clazz = Class.forName(formatterClassName).asSubclass(Formatter.class);
            Constructor<Formatter> cons = null;
            try {
                cons = clazz.getConstructor(Properties.class, LogManager.class);
            }
            catch (Exception exception) {}
            if (cons != null) {
                return cons.newInstance(props, logManager);
            }
            return (Formatter)Class.forName(formatterClassName).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Level getLoggerLevel(Logger logger, LogManager logManager, Properties props) {
        String propName = String.valueOf(logger.getName()) + ".level";
        String levelName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            return Level.parse(levelName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean getUseParentHandlersFlag(Logger logger, LogManager logManager, Properties props) {
        String propName = String.valueOf(logger.getName()) + ".useParentHandlers";
        String propValue = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (propValue == null) {
            return false;
        }
        try {
            return Boolean.valueOf(propValue);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getPropertyValue(String propName, LogManager logManager, Properties props) {
        String propVal = props.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        propVal = logManager.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        return null;
    }

    public static String digestCalcResponse(String HA1, String nonce, String nonceCount, String cNonce, String qop, String method, String uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(method);
            plaintext.append(":");
            plaintext.append(uri);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            String HA2 = IOHelper.bytesToHex(digest.digest());
            plaintext.setLength(0);
            plaintext.append(HA1);
            plaintext.append(":");
            plaintext.append(nonce);
            plaintext.append(":");
            if (qop != null) {
                plaintext.append(nonceCount);
                plaintext.append(":");
                plaintext.append(cNonce);
                plaintext.append(":");
                plaintext.append(qop);
                plaintext.append(":");
            }
            plaintext.append(HA2);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestCalcHA1(String userName, String realm, String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(userName);
            plaintext.append(":");
            plaintext.append(realm);
            plaintext.append(":");
            plaintext.append(password);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static class Credentials
    implements UserCredentials {
        private String user;
        private String password;
        private static final AtomicLong nonceCounter = new AtomicLong();

        public Credentials(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUserName() {
            return this.user;
        }

        public String toHttpBasicAuth() {
            try {
                return "basic " + Base64.encodeBytes((String.valueOf(this.user) + ":" + this.password).getBytes("UTF-8"), 8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "basic " + Base64.encodeBytes((String.valueOf(this.user) + ":" + this.password).getBytes(), 8);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toHttpDigestAuth(String method, String uri, String challengeHeader) {
            if (challengeHeader == null || !challengeHeader.startsWith("Digest ")) {
                return null;
            }
            String[] pairs = challengeHeader.substring("Digest ".length()).split(", +");
            HashMap<String, String> params = new HashMap<String, String>();
            String[] stringArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] nv = pair.split("=", 2);
                params.put(nv[0].toLowerCase(), nv[1].substring(1, nv[1].length() - 1));
                ++n2;
            }
            String realm = (String)params.get("realm");
            String HA1 = ContentSourceImpl.digestCalcHA1(this.user, realm, this.password);
            String nonce = (String)params.get("nonce");
            String qop = (String)params.get("qop");
            String opaque = (String)params.get("opaque");
            byte[] bytes = new byte[16];
            Random random = random;
            synchronized (random) {
                random.nextBytes(bytes);
            }
            String cNonce = IOHelper.bytesToHex(bytes);
            String nonceCount = Long.toHexString(nonceCounter.incrementAndGet());
            String response = ContentSourceImpl.digestCalcResponse(HA1, nonce, nonceCount, cNonce, qop, method, uri);
            StringBuilder buf = new StringBuilder();
            buf.append("Digest username=\"");
            buf.append(this.user);
            buf.append("\", realm=\"");
            buf.append(realm);
            buf.append("\", nonce=\"");
            buf.append(nonce);
            buf.append("\", uri=\"");
            buf.append(uri);
            buf.append("\", qop=\"auth\", nc=\"");
            buf.append(nonceCount);
            buf.append("\", cnonce=\"");
            buf.append(cNonce);
            buf.append("\", response=\"");
            buf.append(response);
            buf.append("\", opaque=\"");
            buf.append(opaque);
            buf.append("\"");
            return buf.toString();
        }

        public String toString() {
            return "user=" + this.user;
        }
    }
}

