/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.xcc.AdhocQuery;
import org.eclipse.wst.xquery.marklogic.xcc.Content;
import org.eclipse.wst.xquery.marklogic.xcc.ContentSource;
import org.eclipse.wst.xquery.marklogic.xcc.ContentbaseMetaData;
import org.eclipse.wst.xquery.marklogic.xcc.ModuleInvoke;
import org.eclipse.wst.xquery.marklogic.xcc.ModuleSpawn;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.ResultItem;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.UserCredentials;
import org.eclipse.wst.xquery.marklogic.xcc.Version;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.StreamingResultException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.AdhocImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.CBMetaDataImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.ContentSourceImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.ModuleImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.RequestImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.StreamingResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ContentInsertController;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.EvalRequestController;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.SingleHostAddress;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSDecimal;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSInteger;

public class SessionImpl
implements Session {
    private final Set<StreamingResultSequence> activeResultSeqs;
    private final ContentSource contentSource;
    private final ConnectionProvider provider;
    private final UserCredentials credentials;
    private final String contentBase;
    private Logger logger = null;
    private RequestOptions defaultOptions = new RequestOptions();
    private boolean autoCommit = true;
    private boolean closed = false;
    private Object userObject = null;
    private AuthType authType = AuthType.NONE;
    private String challenge;
    private static final String agentString = "Java/" + System.getProperty("java.version") + " MarkXDBC/" + Version.getVersionMajor() + "." + Version.getVersionMinor() + "-" + Version.getVersionPatch();

    public SessionImpl(ContentSource contentSource, ConnectionProvider connectionProvider, UserCredentials credentials, String contentBase) {
        this.contentSource = contentSource;
        this.provider = connectionProvider;
        this.credentials = credentials;
        this.contentBase = contentBase;
        this.activeResultSeqs = Collections.synchronizedSet(new HashSet());
    }

    public UserCredentials getUserCredentials() {
        return this.credentials;
    }

    public String getContentBaseName() {
        return this.contentBase;
    }

    public ContentSource getContentSource() {
        return this.contentSource;
    }

    public void setAutoCommit(boolean autoCommit) {
        if (!autoCommit) {
            throw new UnsupportedOperationException("Multi-request transactions not yet supported");
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void commit() {
        this.assertAutoCommit();
    }

    public void rollback() {
        this.assertAutoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Set<StreamingResultSequence> set = this.activeResultSeqs;
        synchronized (set) {
            Iterator<StreamingResultSequence> it = this.activeResultSeqs.iterator();
            while (it.hasNext()) {
                StreamingResultSequence rs = it.next();
                it.remove();
                try {
                    rs.close();
                }
                catch (StreamingResultException e) {
                    this.getLogger().warning("Exception closing streaming result seq: " + e);
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ModuleInvoke newModuleInvoke(String moduleUri, RequestOptions options) {
        this.assertSessionOpen();
        return new ModuleImpl(this, moduleUri, options, false);
    }

    public ModuleInvoke newModuleInvoke(String moduleUri) {
        return this.newModuleInvoke(moduleUri, null);
    }

    public ModuleSpawn newModuleSpawn(String moduleUri, RequestOptions options) {
        this.assertSessionOpen();
        return new ModuleImpl(this, moduleUri, options, true);
    }

    public ModuleSpawn newModuleSpawn(String moduleUri) {
        return this.newModuleSpawn(moduleUri, null);
    }

    public AdhocQuery newAdhocQuery(String queryText, RequestOptions options) {
        this.assertSessionOpen();
        return new AdhocImpl(this, queryText, options);
    }

    public AdhocQuery newAdhocQuery(String queryText) {
        this.assertSessionOpen();
        return this.newAdhocQuery(queryText, null);
    }

    public void insertContent(Content[] contents) throws RequestException {
        this.assertSessionOpen();
        boolean autoCommit = this.getAutoCommit();
        AdhocQuery request = this.newAdhocQuery("()");
        RequestOptions sessionOptions = this.getDefaultRequestOptions();
        if (sessionOptions.getMaxAutoRetry() == -1 || sessionOptions.getAutoRetryDelayMillis() == -1) {
            RequestOptions options = new RequestOptions();
            if (sessionOptions.getMaxAutoRetry() == -1) {
                options.setMaxAutoRetry(64);
            }
            if (sessionOptions.getAutoRetryDelayMillis() == -1) {
                options.setAutoRetryDelayMillis(125);
            }
            request.setOptions(options);
        }
        this.assertNoTimeStamp(request);
        this.assertNonEmptyUris(request, contents);
        ContentInsertController controller = new ContentInsertController(contents, autoCommit);
        controller.runRequest(this.provider, request, this.getLogger());
    }

    private void assertNonEmptyUris(Request request, Content[] contents) throws RequestException {
        int i = 0;
        while (i < contents.length) {
            String uri = contents[i].getUri();
            if (uri == null || uri.length() == 0) {
                throw new RequestException("Content insertion with empty URI is not allowed", request);
            }
            ++i;
        }
    }

    private void assertNoTimeStamp(Request request) throws RequestException {
        RequestOptions options = this.getEffectiveRequestOptions();
        if (options.getEffectivePointInTime() == null) {
            return;
        }
        if (options.getEffectivePointInTime().equals(BigInteger.ZERO)) {
            return;
        }
        throw new RequestException("Content insertion not allowed with non-zero Point-In-Time", request);
    }

    public void insertContent(Content content) throws RequestException {
        this.insertContent(new Content[]{content});
    }

    public ContentbaseMetaData getContentbaseMetaData() {
        return new CBMetaDataImpl(this);
    }

    public void setDefaultRequestOptions(RequestOptions options) {
        this.defaultOptions = options == null ? new RequestOptions() : options;
    }

    public RequestOptions getDefaultRequestOptions() {
        return this.defaultOptions;
    }

    public Logger getLogger() {
        return this.logger == null ? this.contentSource.getDefaultLogger() : this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public ResultSequence submitRequest(Request request) throws RequestException {
        this.assertSessionOpen();
        if (request.getSession() != this || !(request instanceof RequestImpl)) {
            this.throwIllegalArg("Request object was not created by this session", this.getLogger());
        }
        RequestImpl req = (RequestImpl)request;
        EvalRequestController controller = new EvalRequestController(req.serverPath(), req.encodedQueryString(this.getLogger()));
        return controller.runRequest(this.provider, request, this.getLogger());
    }

    public BigInteger getCurrentServerPointInTime() throws RequestException {
        AdhocQuery pitReq = this.newAdhocQuery("xdmp:request-timestamp()");
        ResultSequence rs = this.submitRequest(pitReq);
        ResultItem item = rs.next();
        BigInteger stamp = null;
        stamp = item.getItem() instanceof XSDecimal ? ((XSDecimal)item.getItem()).asBigDecimal().toBigInteger() : ((XSInteger)item.getItem()).asBigInteger();
        rs.close();
        return stamp;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public URI getConnectionUri() {
        if (!(this.provider instanceof SingleHostAddress)) {
            return null;
        }
        InetSocketAddress addr = ((SingleHostAddress)((Object)this.provider)).getAddress();
        try {
            return new URI("xcc", String.valueOf(this.getUserCredentials().getUserName()) + ":xxxx", addr.getHostName(), addr.getPort(), this.getContentBaseName() == null ? null : "/" + this.getContentBaseName(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void registerResultSequence(StreamingResultSequence resultSequence) {
        this.activeResultSeqs.add(resultSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterResultSequence(StreamingResultSequence resultSequence) {
        Set<StreamingResultSequence> set = this.activeResultSeqs;
        synchronized (set) {
            if (this.activeResultSeqs.contains(resultSequence)) {
                this.activeResultSeqs.remove(resultSequence);
            }
        }
    }

    public RequestOptions getEffectiveRequestOptions() {
        RequestOptions eff = new RequestOptions();
        RequestOptions ses = this.getDefaultRequestOptions();
        eff.applyEffectiveValues(new RequestOptions[]{ses});
        return eff;
    }

    public ConnectionProvider getProvider() {
        return this.provider;
    }

    public String userAgentString() {
        return agentString;
    }

    public boolean processAuthChallenge(String challenge) {
        AuthType authType = AuthType.valueOf(challenge.split(" ")[0].toUpperCase());
        boolean retryAdvised = authType != this.authType;
        this.authType = authType;
        this.challenge = challenge;
        return retryAdvised;
    }

    public String getAuthString(String method, String uri) {
        switch (this.authType) {
            case BASIC: {
                return this.credentials.toHttpBasicAuth();
            }
            case DIGEST: {
                return ((ContentSourceImpl.Credentials)this.credentials).toHttpDigestAuth(method, uri, this.challenge);
            }
        }
        return null;
    }

    private void assertSessionOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    private void assertAutoCommit() {
        if (!this.autoCommit) {
            throw new UnsupportedOperationException("Explicit transactions not yet supported");
        }
    }

    private void throwIllegalArg(String msg, Logger logger) {
        logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    public String toString() {
        return String.valueOf(this.credentials.toString()) + ", cb=" + (this.contentBase == null ? "{default}" : this.contentBase) + " [ContentSource: " + this.contentSource.toString() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthType {
        NONE,
        BASIC,
        DIGEST;

    }
}

