/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl.handlers;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.http.HttpChannel;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.UserCredentials;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestPermissionException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.ServerResponseException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SessionImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ResponseHandler;

public class UnauthorizedHandler
implements ResponseHandler {
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws RequestException {
        String challenge;
        try {
            challenge = http.getResponseHeader("www-authenticate");
        }
        catch (IOException iOException) {
            throw new ServerResponseException("Failed checking authenticate header.", request, responseCode, this.getResponseMessage(http));
        }
        SessionImpl session = (SessionImpl)request.getSession();
        boolean retryAdvised = challenge != null ? session.processAuthChallenge(challenge) : false;
        UserCredentials credentials = request.getSession().getUserCredentials();
        String userName = credentials.getUserName();
        String message = "Authorization failed for user '" + userName + "'.";
        throw new RequestPermissionException(message, request, userName, retryAdvised);
    }

    private String getResponseMessage(HttpChannel http) {
        try {
            return http.getResponseMessage();
        }
        catch (IOException iOException) {
            return "No Message";
        }
    }
}

