/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XSFloat;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractStringItem;

public class XsFloatImpl
extends AbstractStringItem
implements XSFloat {
    private final Float value;
    private final BigDecimal bigDecimalValue;
    private final NumberFormatException formatException;

    public XsFloatImpl(String bodyString) {
        super(ValueType.XS_FLOAT, bodyString);
        this.value = Float.valueOf(this.scrubbedFloatValue(bodyString));
        BigDecimal tmpBigDecimal = null;
        NumberFormatException tmpEx = null;
        try {
            tmpBigDecimal = new BigDecimal(bodyString);
        }
        catch (NumberFormatException e) {
            tmpEx = e;
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    public XsFloatImpl(Object value) {
        super(ValueType.XS_FLOAT, value.toString());
        NumberFormatException tmpEx;
        BigDecimal tmpBigDecimal;
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof BigDecimal || value instanceof BigInteger || value instanceof String) {
            this.value = new Float(value.toString());
            tmpBigDecimal = null;
            tmpEx = null;
            try {
                tmpBigDecimal = new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                tmpEx = e;
            }
        } else {
            throw new IllegalArgumentException("Cannot construct XSFloat from " + value.getClass().getName());
        }
        this.bigDecimalValue = tmpBigDecimal;
        this.formatException = tmpEx;
    }

    public Float asFloat() {
        return this.value;
    }

    public float asPrimitiveFloat() {
        return this.value.floatValue();
    }

    public BigDecimal asBigDecimal() {
        if (this.bigDecimalValue == null) {
            throw this.formatException;
        }
        return this.bigDecimalValue;
    }
}

