/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.zorba;

import java.net.URI;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.wst.xquery.core.XQDTUriResolver;

public class ZorbaUriResolver
extends XQDTUriResolver {
    public ISourceModule locateSourceModule(URI uri, IScriptProject project) {
        ISourceModule module;
        if (uri.toString().startsWith("http://www.zorba-xquery.com/modules/") || uri.toString().startsWith("http://www.zorba-xquery.com/zorba/")) {
            return this.findBuiltinModule(project, uri);
        }
        if (uri.toString().startsWith("http://www.expath.org/mod/") && (module = this.findBuiltinModule(project, uri)) != null) {
            return module;
        }
        return super.locateSourceModule(uri, project);
    }

    private ISourceModule findBuiltinModule(IScriptProject project, URI uri) {
        try {
            IScriptFolder[] folders;
            String name = new Path(uri.getPath()).lastSegment();
            IScriptFolder[] iScriptFolderArray = folders = project.getScriptFolders();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptFolder folder = iScriptFolderArray[n2];
                if (folder.isReadOnly()) {
                    ISourceModule[] modules;
                    ISourceModule[] iSourceModuleArray = modules = folder.getSourceModules();
                    int n3 = modules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISourceModule module = iSourceModuleArray[n4];
                        if (module instanceof IExternalSourceModule && module.getPath().removeFileExtension().lastSegment().equals(name)) {
                            return module;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {}
        return null;
    }
}

