/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core.semantic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.wst.xquery.core.semantic.SemanticCheckError;
import org.eclipse.wst.xquery.core.utils.PathUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticCheckErrorReportReader {
    private String fData;
    private ISourceModule fModule;

    public SemanticCheckErrorReportReader(ISourceModule module, String data) {
        this.fData = data;
        this.fModule = module;
    }

    public List<SemanticCheckError> getErrors() {
        if (this.fData == null || this.fData.length() == 0) {
            return null;
        }
        ArrayList<SemanticCheckError> list = new ArrayList<SemanticCheckError>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(new ByteArrayInputStream(this.fData.getBytes()));
            Element rootElement = document.getDocumentElement();
            NodeList errors = rootElement.getElementsByTagName("error");
            int i = 0;
            while (i < errors.getLength()) {
                Element error = (Element)errors.item(i);
                SemanticCheckError semErr = this.readError(error);
                if (semErr != null) {
                    list.add(semErr);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private SemanticCheckError readError(Element error) {
        String errorCode = "";
        String module = "";
        String description = "";
        int lineStart = -1;
        int lineEnd = -1;
        int columnStart = -1;
        int columnEnd = -1;
        Document document = null;
        errorCode = error.getAttribute("code");
        Node child = error.getFirstChild();
        do {
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("location")) {
                Element loc = (Element)child;
                module = loc.getAttribute("module");
                Path fullPath = new Path(module);
                IPath path = PathUtil.makePathRelativeTo((IPath)fullPath, this.fModule.getScriptProject().getResource().getLocation());
                path = this.fModule.getScriptProject().getProject().getFullPath().append(path);
                module = path.toString();
                try {
                    IBuffer buffer = this.fModule.getBuffer();
                    document = new Document(buffer.getContents());
                }
                catch (ModelException modelException) {}
                if (document == null) {
                    return null;
                }
                try {
                    lineStart = Integer.parseInt(loc.getAttribute("lineStart"));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    lineEnd = Integer.parseInt(loc.getAttribute("lineEnd"));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    columnStart = Integer.parseInt(loc.getAttribute("columnStart"));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    columnEnd = Integer.parseInt(loc.getAttribute("columnEnd"));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!child.getNodeName().equals("description")) continue;
            description = child.getTextContent();
        } while ((child = child.getNextSibling()) != null);
        try {
            document.get();
            int sourceStart = document.getLineOffset(lineStart - 1) + columnStart;
            int sourceEnd = document.getLineOffset(lineEnd - 1) + columnEnd + 1;
            if (sourceEnd == sourceStart) {
                ++sourceEnd;
            }
            return new SemanticCheckError(module, errorCode, description, lineStart - 1, sourceStart, sourceEnd);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

