/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.wst.xquery.core.model.ast.XQueryModule;

public class LanguageUtil {
    public static int getLanguageLevel(ISourceModule module) {
        if (module instanceof XQueryModule && "1.0-ml".equals(((XQueryModule)module).getVersion())) {
            return 16;
        }
        IScriptProject scriptProject = module.getScriptProject();
        if (scriptProject != null) {
            return LanguageUtil.getLanguageLevel(scriptProject.getProject());
        }
        return 0;
    }

    public static int getLanguageLevel(IProject project) {
        PreferencesLookupDelegate delegate = new PreferencesLookupDelegate(project);
        String language = delegate.getString("org.eclipse.wst.xquery.core", "language.level");
        boolean fulltext = delegate.getBoolean("org.eclipse.wst.xquery.core", "language.use_full_text");
        int mask = 0;
        if (language.equals("XQuery 1.1 + Update Facility")) {
            mask = 1;
        } else if (language.equals("XQuery 1.1 + Scripting Extensions")) {
            mask = 3;
        }
        if (fulltext) {
            mask |= 4;
        }
        return mask |= 8;
    }

    public static boolean hasProjectLanguage(IProject project, int targetLanguageLevel) {
        int currentLanguageLevel = LanguageUtil.getLanguageLevel(project);
        return (currentLanguageLevel & targetLanguageLevel) == targetLanguageLevel;
    }

    public static boolean isLanguage(int currentLanguageLevel, int targetLanguageLevel) {
        return (currentLanguageLevel & targetLanguageLevel) == targetLanguageLevel;
    }
}

