/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.xquery.core.IXQDTUriResolver;
import org.eclipse.wst.xquery.core.XQDTCorePlugin;
import org.eclipse.wst.xquery.core.XQDTUriResolver;

public class ResolverUtil {
    public static IXQDTUriResolver getProjectUriResolver(IProject project) {
        IExtensionPoint extPoint;
        IXQDTUriResolver resolver = null;
        IEclipsePreferences preferences = new ProjectScope(project).getNode("org.eclipse.wst.xquery.core");
        String resolverId = preferences.get("uriResolver", null);
        if (resolverId != null && (extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.core", "uriResolver")) != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                if (extension.getUniqueIdentifier().equals(resolverId)) {
                    try {
                        resolver = (IXQDTUriResolver)extension.getConfigurationElements()[0].createExecutableExtension("class");
                    }
                    catch (InvalidRegistryObjectException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        if (resolver == null) {
            resolver = XQDTCorePlugin.getDefault().getUriResolver();
        }
        return resolver;
    }

    public static IXQDTUriResolver createDefaultUriResolver() {
        return new XQDTUriResolver();
    }
}

