/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.codeassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.wst.xquery.core.codeassist.IImplicitImportActivator;
import org.eclipse.wst.xquery.internal.core.codeassist.ImplicitImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitImportsRegistry {
    private static Map<IScriptProject, List<ImplicitImport>> fImplicitImports = new HashMap<IScriptProject, List<ImplicitImport>>();

    public static List<ImplicitImport> getImplicitImports(IScriptProject project) {
        List<ImplicitImport> result = fImplicitImports.get(project);
        if (result == null) {
            result = ImplicitImportsRegistry.readImplicitImports(project);
            fImplicitImports.put(project, result);
        }
        return result;
    }

    private static List<ImplicitImport> readImplicitImports(IScriptProject project) {
        ArrayList<ImplicitImport> result = new ArrayList<ImplicitImport>();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.launching.implicitImports");
        if (extPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                try {
                    IConfigurationElement[] prefixGroups;
                    IConfigurationElement[] iConfigurationElementArray = prefixGroups = extension.getConfigurationElements();
                    int n3 = prefixGroups.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement prefixGroup = iConfigurationElementArray[n4];
                        IImplicitImportActivator activator = (IImplicitImportActivator)prefixGroup.createExecutableExtension("activator");
                        if (activator.activateForProject(project)) {
                            IConfigurationElement[] prefixes;
                            IConfigurationElement[] iConfigurationElementArray2 = prefixes = prefixGroup.getChildren("prefix");
                            int n5 = prefixes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String path;
                                IConfigurationElement prefix = iConfigurationElementArray2[n6];
                                String name = prefix.getAttribute("name");
                                if (name != null && (path = prefix.getAttribute("path")) != null) {
                                    result.add(new ImplicitImport(name, path));
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return result;
    }
}

