/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.environment;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.EFSFileHandle;
import org.eclipse.wst.xquery.internal.core.environment.RemoteFileHandle;

public class RemoteEnvironment
implements IEnvironment,
IAdaptable {
    public static final String ENVIRONMENT_ID = "org.eclipse.wst.xquery.core.environment.remoteEnvironment";
    private static IEnvironment instance = new RemoteEnvironment();
    private IFileSystem fs = EFS.getLocalFileSystem();

    private RemoteEnvironment() {
    }

    public boolean isLocal() {
        return false;
    }

    public IFileHandle getFile(IPath path) {
        if (path == null) {
            return null;
        }
        if (path.segment(0).equals("[URI]")) {
            if (path.segmentCount() < 4) {
                return null;
            }
            try {
                IPath filePath = path.removeFirstSegments(4);
                String scheme = path.segment(1);
                String auth = path.segment(2);
                String port = path.segment(3);
                StringBuffer sb = new StringBuffer();
                sb.append("^^^".equals(scheme) ? "" : String.valueOf(scheme) + "://");
                sb.append("^^^".equals(auth) ? "" : auth);
                sb.append("^^^".equals(port) ? "" : ":" + port);
                if (filePath.segmentCount() != 0) {
                    sb.append("/" + filePath.toPortableString());
                }
                URI uri = new URI(sb.toString());
                return new RemoteFileHandle(this, uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            IFile[] files;
            IFileStore store = this.fs.getStore(path);
            EFSFileHandle fileHandle = new EFSFileHandle((IEnvironment)this, store);
            if (!fileHandle.exists() && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(path.toFile().toURI())).length == 1) {
                store = this.fs.getStore(files[0].getLocation());
                fileHandle = new EFSFileHandle((IEnvironment)this, store);
            }
            return fileHandle;
        }
        return null;
    }

    public String getId() {
        return ENVIRONMENT_ID;
    }

    public static IEnvironment getInstance() {
        return instance;
    }

    public String getSeparator() {
        return "/";
    }

    public char getSeparatorChar() {
        return '/';
    }

    public String getName() {
        return "Remote";
    }

    public String convertPathToString(IPath path) {
        return EnvironmentPathUtils.getLocalPath((IPath)path).toOSString();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public URI getURI(IPath location) {
        return URIUtil.toURI((IPath)location);
    }

    public IFileHandle getFile(URI locationURI) {
        return new EFSFileHandle((IEnvironment)this, this.fs.getStore(locationURI));
    }

    public String getPathsSeparator() {
        return Character.toString(this.getPathsSeparatorChar());
    }

    public char getPathsSeparatorChar() {
        return Platform.getOS().equals("win32") ? (char)';' : ':';
    }

    public String getCanonicalPath(IPath path) {
        try {
            return path.toFile().getCanonicalFile().toString();
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return path.toOSString();
        }
    }

    public boolean isConnected() {
        return true;
    }

    public boolean connect() {
        return true;
    }
}

