/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.environment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;

public class RemoteFileHandle
implements IFileHandle {
    public static final String ELIPSE = "^^^";
    private final IEnvironment fEnvironment;
    private final URI fUri;
    private final IPath fPath;

    public RemoteFileHandle(IEnvironment environment, URI uri) {
        this.fEnvironment = environment;
        this.fUri = uri;
        Path path = new Path("[URI]", "/");
        String scheme = this.fUri.getScheme();
        path = path.append(scheme == null ? ELIPSE : scheme);
        String host = this.fUri.getHost();
        path = path.append(host == null ? ELIPSE : host);
        int port = this.fUri.getPort();
        path = path.append(port == -1 ? ELIPSE : "" + port);
        path = path.append(this.fUri.getPath());
        this.fPath = path;
    }

    public boolean exists() {
        return true;
    }

    public String getCanonicalPath() {
        return this.fUri.toString();
    }

    public IFileHandle getChild(String path) {
        return new RemoteFileHandle(this.fEnvironment, this.fUri.resolve(path));
    }

    public IFileHandle[] getChildren() {
        return null;
    }

    public IEnvironment getEnvironment() {
        return this.fEnvironment;
    }

    public String getEnvironmentId() {
        return this.fEnvironment.getId();
    }

    public IPath getFullPath() {
        return this.fPath;
    }

    public String getName() {
        return this.fPath.lastSegment();
    }

    public IFileHandle getParent() {
        return new RemoteFileHandle(this.fEnvironment, this.fUri.resolve(this.fPath.removeLastSegments(1).toPortableString()));
    }

    public IPath getPath() {
        return this.fPath;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isSymlink() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        return null;
    }

    public OutputStream openOutputStream(IProgressMonitor monitor) throws IOException {
        return null;
    }

    public String toOSString() {
        return this.fUri.toString();
    }

    public URI toURI() {
        return this.fUri;
    }
}

