/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.parser.antlr;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.xquery.internal.core.parser.antlr.NewLazyTokenStream;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQDTCommonErrorNode;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQDTCommonTree;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQDTCommonTreeAdaptor;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQueryLexer;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQueryParser;
import org.eclipse.wst.xquery.internal.core.parser.visitors.XQDTCommonTreeVisitor;

public class Test {
    public static void main(String[] args) {
        String input = "exit with with + (exit with exit)";
        ANTLRStringStream source = new ANTLRStringStream(input);
        XQueryLexer lexer = new XQueryLexer((CharStream)source);
        NewLazyTokenStream stream = new NewLazyTokenStream(lexer);
        stream.jumpToFirstValidToken();
        XQueryParser p = new XQueryParser(stream);
        p.setCharSource(source);
        p.setTreeAdaptor((TreeAdaptor)new XQDTCommonTreeAdaptor(null));
        p.setLanguageLevel(3);
        try {
            XQueryParser.p_Module_return m = p.p_Module();
            if (m != null) {
                System.out.println(m.tree.toStringTree());
            }
            System.out.println("------KW------");
            for (Position pos : p.getKeywords()) {
                System.out.println(input.substring(pos.offset, pos.offset + pos.length));
            }
            System.out.println("--------------");
            CommonTree tree = (CommonTree)m.getTree();
            XQDTCommonTreeVisitor visitor = new XQDTCommonTreeVisitor(input.toCharArray(), null);
            ((XQDTCommonTree)tree).accept(visitor);
            if (tree instanceof XQDTCommonErrorNode) {
                System.out.println("Error\n-----");
                Test.analyzeError((CommonErrorNode)tree);
                return;
            }
            if (tree.getChildCount() > 0 && tree.getChild(0) instanceof CommonErrorNode) {
                Test.analyzeError((CommonErrorNode)tree.getChild(0));
                return;
            }
            System.out.println(m.getTree().toString());
            Test.printTree(tree, 1);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
    }

    private static void analyzeError(CommonErrorNode error) throws RecognitionException {
        throw error.trappedException;
    }

    private static void printTree(CommonTree tree, int i) {
        for (Object oc : tree.getChildren()) {
            CommonTree child = (CommonTree)oc;
            if (child.token != null && child.token.getType() != -1) {
                System.out.println(String.valueOf(Test.getIndent(i)) + child.token.getText() + " (" + child.getType() + ")");
            } else {
                System.out.println("---------EOF---------");
            }
            if (child.getChildren() == null) continue;
            Test.printTree(child, i + 1);
        }
    }

    private static String getIndent(int count) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }
}

