/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xquery.set.launching.deploy.DeployInfo;

public class SETDeployProjectSecondWizardPage
extends WizardPage {
    private Button fDeployDataCheckButton;
    private Label fDeployDataDescriptionLabel;
    private Label fDefaultServerLabel;
    private Text fCustomServerText;
    private SelectionButtonDialogField fDefaultServerRadioField;
    private SelectionButtonDialogField fCustomServerRadioField;
    private WidgetListener fListener = new WidgetListener();
    private IScriptProject fProject;
    private static final String DESCRIPTION = "Choose custom deployment options";

    protected SETDeployProjectSecondWizardPage(IScriptProject project) {
        super("Deploy Sausalito Project");
        this.setTitle("Deployment Options");
        this.setDescription(DESCRIPTION);
        this.fProject = project;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        this.createServerOptionsGroup(composite);
    }

    private void createDeployDataButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.fDeployDataCheckButton = SWTFactory.createCheckButton((Composite)composite, (String)"Deploy project data", (int)2);
        this.fDeployDataCheckButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDeployDataCheckButton.setSelection(true);
        this.fDeployDataDescriptionLabel = new Label(composite, 64);
        this.fDeployDataDescriptionLabel.setText("If this option is enabled, after a succesful project deployment, the local data\nin the \"bulkload\" directory will be appended to the deployed project data.");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.fDeployDataDescriptionLabel.setLayoutData((Object)gd);
        this.fDeployDataDescriptionLabel.setEnabled(false);
    }

    private void createServerOptionsGroup(Composite composite) {
        Group group = SWTFactory.createGroup((Composite)composite, (String)"Deployment URL", (int)3, (int)1, (int)768);
        this.fDefaultServerRadioField = new SelectionButtonDialogField(16);
        this.fDefaultServerRadioField.setLabelText("Default server: ");
        this.fDefaultServerRadioField.setSelection(true);
        this.fDefaultServerRadioField.setDialogFieldListener((IDialogFieldListener)this.fListener);
        this.fDefaultServerRadioField.doFillIntoGrid((Composite)group, 2);
        this.fDefaultServerLabel = new Label((Composite)group, 0);
        this.fDefaultServerLabel.setText("http://portal.28msec.com/");
        this.fCustomServerRadioField = new SelectionButtonDialogField(16);
        this.fCustomServerRadioField.setLabelText("Custom server: ");
        this.fCustomServerRadioField.setDialogFieldListener((IDialogFieldListener)this.fListener);
        this.fCustomServerRadioField.doFillIntoGrid((Composite)group, 2);
        this.fCustomServerText = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.fCustomServerText.addModifyListener((ModifyListener)this.fListener);
        this.fCustomServerText.setEnabled(false);
    }

    private void isValid() {
        if (this.fCustomServerRadioField.isSelected()) {
            String server = this.fCustomServerText.getText();
            try {
                URL url = new URL(server);
                String host = url.getHost();
                if (host == null || host.length() == 0) {
                    this.setErrorMessage("The URL host cannot be empty.");
                    this.setPageComplete(false);
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.setErrorMessage("The deployment URL is invalid.");
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    DeployInfo configureDeployInfo(DeployInfo info) {
        String host = info.getHost();
        if (this.fCustomServerRadioField.isSelected()) {
            host = this.fCustomServerText.getText();
        }
        return new DeployInfo(info.getProject(), info.getProjectConfig(), info.getApplicationName(), info.getUserName(), info.getPassword(), info.getDeployType(), host);
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IDialogFieldListener {
        private WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == SETDeployProjectSecondWizardPage.this.fDeployDataCheckButton) {
                SETDeployProjectSecondWizardPage.this.fDeployDataDescriptionLabel.setEnabled(SETDeployProjectSecondWizardPage.this.fDeployDataCheckButton.getSelection());
            }
            SETDeployProjectSecondWizardPage.this.isValid();
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == SETDeployProjectSecondWizardPage.this.fCustomServerRadioField) {
                SETDeployProjectSecondWizardPage.this.fCustomServerText.setEnabled(true);
            } else if (field == SETDeployProjectSecondWizardPage.this.fDefaultServerRadioField) {
                SETDeployProjectSecondWizardPage.this.fCustomServerText.setEnabled(false);
            }
            SETDeployProjectSecondWizardPage.this.isValid();
        }

        public void modifyText(ModifyEvent e) {
            SETDeployProjectSecondWizardPage.this.isValid();
        }
    }
}

