/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETDeployDataJob;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETDeployProjectJob;
import org.eclipse.wst.xquery.set.internal.ui.util.SETPluginImages;
import org.eclipse.wst.xquery.set.internal.ui.wizards.SETDeployProjectFirstWizardPage;
import org.eclipse.wst.xquery.set.internal.ui.wizards.SETDeployProjectSecondWizardPage;
import org.eclipse.wst.xquery.set.launching.deploy.DeployInfo;
import org.eclipse.wst.xquery.set.launching.deploy.DeployManager;
import org.eclipse.wst.xquery.set.launching.deploy.Deployer;

public class SETDeployProjectWizard
extends Wizard {
    private IScriptProject fProject;
    private SETDeployProjectFirstWizardPage fFirstPage;
    private SETDeployProjectSecondWizardPage fSecondPage;

    public SETDeployProjectWizard(IScriptProject project) {
        this.setDefaultPageImageDescriptor(SETPluginImages.DESC_WIZBAN_DEPLOY_PROJECT);
        this.fProject = project;
    }

    public void addPages() {
        this.fFirstPage = new SETDeployProjectFirstWizardPage(this.fProject);
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new SETDeployProjectSecondWizardPage(this.fProject);
        this.addPage((IWizardPage)this.fSecondPage);
        this.setWindowTitle("Deploy Sausalito Project");
    }

    public boolean performFinish() {
        DeployInfo tmpInfo = this.fFirstPage.getDeployInfo();
        tmpInfo = this.fSecondPage.configureDeployInfo(tmpInfo);
        boolean useCache = this.fFirstPage.cacheCredentials();
        final DeployInfo info = tmpInfo;
        Deployer deployer = DeployManager.getInstance().getDeployer(info, useCache);
        deployer.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Job job = event.getJob();
                IStatus status = job.getResult();
                if (job instanceof SETDeployProjectJob) {
                    if (status.isOK()) {
                        this.displayMessageBox("The project \"" + info.getProject().getElementName() + "\" was succesfully deployed as application \"" + info.getApplicationName() + "\"", true);
                    }
                } else if (job instanceof SETDeployDataJob && status.isOK()) {
                    this.displayMessageBox("The data for project \"" + info.getProject().getElementName() + "\" was succesfully deployed into the application \"" + info.getApplicationName() + "\"", true);
                }
            }

            private void displayMessageBox(final String message, final boolean isSuccess) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageBox mb = new MessageBox(new Shell(Display.getDefault().getActiveShell()), (isSuccess ? 2 : 1) | 0x20);
                        mb.setMessage(message);
                        mb.open();
                    }
                });
            }
        });
        deployer.execute();
        return true;
    }
}

