/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.wst.xquery.internal.ui.text.rules.ExpressionRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQDTCodeScanner
extends AbstractScriptScanner {
    private static String[] fgTokenProperties = new String[]{"DLTK_keyword", "DLTK_default", "XQDT_variable", "XQDT_function", "XQDT_item_type", "XQDT_xml_tag"};

    public XQDTCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        this.addDolarRule(rules);
        this.addElementEndTagRule(rules);
        this.addElementEmptyTagRule(rules);
        this.addElementStartTagNoAttrRule(rules);
        this.addElementStartTagAttrRule(rules);
        this.addFunctionRule(rules);
        this.addItemType(rules);
        Token other = this.getToken("DLTK_default");
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    private void addDolarRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_default");
        expression.addRuleSegment("$", (IToken)token);
        token = this.getToken("XQDT_variable");
        expression.addRuleSegment("${qn}", (IToken)token);
        rules.add(expression);
    }

    private void addFunctionRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("XQDT_function");
        expression.addRuleSegment("${fqn}", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("(", (IToken)token);
        rules.add(expression);
    }

    private void addItemType(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("XQDT_item_type");
        expression.addRuleSegment("${it}", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("(", (IToken)token);
        rules.add(expression);
    }

    private void addLetRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("let", (IToken)token);
        token = this.getToken("XQDT_variable");
        expression.addRuleSegment("$", (IToken)token, true);
        rules.add(expression);
    }

    private void addForRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("for", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("$", (IToken)token, true);
        rules.add(expression);
    }

    private void addReturnRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("return", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("$", (IToken)token, true);
        rules.add(expression);
    }

    private void addWhereRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("where", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("$", (IToken)token, true);
        rules.add(expression);
    }

    private void addIfRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("if", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("(", (IToken)token);
        rules.add(expression);
    }

    private void addTypeswitchRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("typeswitch", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("(", (IToken)token);
        rules.add(expression);
    }

    private void addWhileRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("while", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("(", (IToken)token);
        rules.add(expression);
    }

    private void addElementStartTagNoAttrRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        expression.setTolleratesWhitespaces(false);
        Token token = this.getToken("DLTK_default");
        expression.addRuleSegment("<", (IToken)token);
        token = this.getToken("XQDT_xml_tag");
        expression.addRuleSegment("${qn}", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${ws}", (IToken)token);
        expression.addRuleSegment(">", (IToken)token);
        rules.add(expression);
    }

    private void addElementStartTagAttrRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        expression.setTolleratesWhitespaces(false);
        Token token = this.getToken("DLTK_default");
        expression.addRuleSegment("<", (IToken)token);
        token = this.getToken("XQDT_xml_tag");
        expression.addRuleSegment("${qn}", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${ws}", (IToken)token);
        expression.addRuleSegment("${qn}", (IToken)token, true);
        expression.addRuleSegment("${ws}", (IToken)token);
        expression.addRuleSegment("=", (IToken)token);
        rules.add(expression);
    }

    private void addElementEmptyTagRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        expression.setTolleratesWhitespaces(false);
        Token token = this.getToken("DLTK_default");
        expression.addRuleSegment("<", (IToken)token);
        token = this.getToken("XQDT_xml_tag");
        expression.addRuleSegment("${qn}", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${ws}", (IToken)token);
        expression.addRuleSegment("/>", (IToken)token);
        rules.add(expression);
    }

    private void addElementEndTagRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        expression.setTolleratesWhitespaces(false);
        Token token = this.getToken("DLTK_default");
        expression.addRuleSegment("</", (IToken)token);
        token = this.getToken("XQDT_xml_tag");
        expression.addRuleSegment("${qn}", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${ws}", (IToken)token);
        expression.addRuleSegment(">", (IToken)token);
        rules.add(expression);
    }

    private void addDeclareFunctionRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("declare", (IToken)token);
        token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("function", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${qn}", (IToken)token, true);
        rules.add(expression);
    }

    private void addDeclareUpdatingFunctionRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("declare", (IToken)token);
        token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("updating", (IToken)token);
        token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("function", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${qn}", (IToken)token, true);
        rules.add(expression);
    }

    private void addDeclareVariableRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("declare", (IToken)token);
        token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("$", (IToken)token, true);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${qn}", (IToken)token);
        rules.add(expression);
    }

    private void addDeclareSequentialFunctionRule(List<IRule> rules) {
        ExpressionRule expression = new ExpressionRule();
        Token token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("declare", (IToken)token);
        token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("sequential", (IToken)token);
        token = this.getToken("DLTK_keyword");
        expression.addRuleSegment("function", (IToken)token);
        token = this.getToken("DLTK_default");
        expression.addRuleSegment("${qn}", (IToken)token, true);
        rules.add(expression);
    }
}

