/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text;

import java.util.LinkedList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XMLLexer;

public class XQDTXMLAutoInserter
implements VerifyKeyListener {
    private final ScriptEditor editor;

    public XQDTXMLAutoInserter(ScriptEditor editor) {
        this.editor = editor;
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ScriptEditor.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '\"': 
            case '\'': 
            case '/': 
            case '>': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        String source = document.get();
        String begin = source.substring(0, offset);
        source.substring(offset);
        try {
            IRegion startLine = document.getLineInformationOfOffset(offset);
            document.getLineInformationOfOffset(offset + length);
            begin = begin.substring(startLine.getOffset());
            if (event.character == '>') {
                this.computeClosingTag(document, begin, offset, length);
                return;
            }
            if (event.character == '/') {
                this.computeClosingTag(document, begin, offset, length, true);
                return;
            }
            ANTLRStringStream input = new ANTLRStringStream(String.valueOf(begin) + event.character);
            XMLLexer lexer = new XMLLexer((CharStream)input);
            Token token = null;
            Token lastToken = null;
            boolean isInQuotAttr = false;
            boolean isInAposAttr = false;
            while ((token = lexer.nextToken()).getType() != -1) {
                lastToken = token;
                isInQuotAttr = lexer.isInQuotAttr();
                isInAposAttr = lexer.isInAposAttribute();
            }
            if (event.character == '\"' && lastToken.getType() == 235 && isInQuotAttr && !isInAposAttr || event.character == '\'' && lastToken.getType() == 234 && isInAposAttr && !isInQuotAttr) {
                document.replace(offset, length, String.valueOf(event.character));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private XMLLexer getXMLLexer(String source) {
        return new XMLLexer((CharStream)new ANTLRStringStream(source));
    }

    private XQDTXMLAutoInserter computeClosingTag(IDocument document, String source, int offset, int length) throws Exception {
        return this.computeClosingTag(document, source, offset, length, false);
    }

    private XQDTXMLAutoInserter computeClosingTag(IDocument document, String source, int offset, int length, boolean isSingleTag) throws Exception {
        if (document.get().charAt(offset - 1) == '/') {
            return this;
        }
        XMLLexer lexer = this.getXMLLexer(source);
        Token token = null;
        LinkedList<String> tagName = new LinkedList<String>();
        LinkedList<Token> tokens = new LinkedList<Token>();
        while ((token = lexer.nextToken()).getType() != -1 && token.getCharPositionInLine() < offset) {
            tokens.add(token);
        }
        int i = tokens.size() - 1;
        while (i >= 0) {
            token = (Token)tokens.get(i);
            if (token.getType() == 209) {
                String tag = "";
                int j = tagName.size() - 1;
                while (j >= 0) {
                    tag = String.valueOf(tag) + (String)tagName.get(j);
                    --j;
                }
                String[] tags = tag.split(" ");
                if (!tags[0].matches("[A-Za-z_][A-Za-z_:\\-]*(:[A-Za-z_][A-Za-z_:\\-]*)?") || tags.length != 1) break;
                if (isSingleTag) {
                    document.replace(offset, length, ">");
                    break;
                }
                document.replace(offset, length, "</" + tags[0] + '>');
                break;
            }
            tagName.add(token.getText());
            --i;
        }
        return this;
    }
}

