/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.debug.ui.dialogs;

import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xquery.set.internal.debug.ui.launchConfigurations.SocketSelectionBlock;
import org.eclipse.wst.xquery.set.internal.launching.server.Server;

public class BusySocketDialog
extends TrayDialog {
    private SocketSelectionBlock fSocketBlock;
    private WidgetListener fListener = new WidgetListener();
    private String fHost;
    private int fPort;

    protected BusySocketDialog(Shell shell, Server server) {
        super(shell);
        this.fHost = server.getHost();
        this.fPort = server.getPort();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        SWTFactory.createLabel((Composite)composite, (String)"This socket is already in use. Choose another one:", (int)1);
        this.createSocketBlock(composite);
        this.initializeDialogData();
        return composite;
    }

    private void initializeDialogData() {
        this.getShell().setText("Socket already in use");
        this.fSocketBlock.fIpCombo.setText(this.fHost);
        this.fSocketBlock.fPortSpinner.setSelection(this.fPort);
        this.fSocketBlock.fPortSpinner.setFocus();
    }

    protected void createSocketBlock(Composite comp) {
        this.fSocketBlock = new SocketSelectionBlock(comp);
        this.fSocketBlock.addSelectionListener(this.fListener);
    }

    public String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    private class WidgetListener
    implements SelectionListener {
        private WidgetListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == ((BusySocketDialog)BusySocketDialog.this).fSocketBlock.fIpCombo) {
                BusySocketDialog.this.fHost = ((BusySocketDialog)BusySocketDialog.this).fSocketBlock.fIpCombo.getText();
            } else if (e.widget == ((BusySocketDialog)BusySocketDialog.this).fSocketBlock.fPortSpinner) {
                BusySocketDialog.this.fPort = ((BusySocketDialog)BusySocketDialog.this).fSocketBlock.fPortSpinner.getSelection();
            }
        }
    }
}

