/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;
import org.eclipse.wst.xquery.debug.dbgp.client.IDbgpTranslator;
import org.eclipse.wst.xquery.debug.debugger.zorba.ZorbaDebuggerPlugin;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.ZorbaDbgpTranslator;
import org.eclipse.wst.xquery.launching.TranslatableDebuggingEngineRunner;

public class ZorbaDebuggerRunner
extends TranslatableDebuggingEngineRunner {
    private static List<String> DEFAULT_ARGS = Arrays.asList("-f", "-q");
    private static final String NO_LOGO_KEY = "--no-logo";
    private static final String DEBUG_SERVER_KEY = "--debug-server";
    private static final String PORTS_KEY = "-p";

    public ZorbaDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.wst.xquery.debug.core";
    }

    protected String getDebuggingEngineId() {
        return "org.eclipse.wst.xquery.debug.engines.zorba";
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return "org.eclipse.wst.xquery.debug.debugger.zorba";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected String[] renderCommandLine(InterpreterConfig config) {
        String[] cmdLine = super.renderCommandLine(config);
        ArrayList<String> newCmdLine = new ArrayList<String>(Arrays.asList(cmdLine));
        int index = newCmdLine.size() - config.getScriptArgs().size() - 1;
        newCmdLine.addAll(index, DEFAULT_ARGS);
        return newCmdLine.toArray(new String[newCmdLine.size()]);
    }

    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate, ILaunch launch) throws CoreException {
        InterpreterConfig newConfig = (InterpreterConfig)config.clone();
        newConfig.addInterpreterArg(NO_LOGO_KEY);
        newConfig.addInterpreterArg(DEBUG_SERVER_KEY);
        newConfig.addInterpreterArg(PORTS_KEY);
        String ports = delegate.getString(this.getDebuggingEnginePreferenceQualifier(), "debugging_engine_server_ports");
        newConfig.addInterpreterArg(ports);
        config.setProperty("debugging_engine_server_ports", (Object)ports);
        return newConfig;
    }

    protected boolean needsDbgpTranslator(PreferencesLookupDelegate delegate) {
        return delegate.getBoolean(this.getDebuggingEnginePreferenceQualifier(), "debugging_engine_needs_dbgp_translator");
    }

    protected IDbgpTranslator getDbgpTranslator(InterpreterConfig config, IScriptProject project) {
        DbgpConnectionConfig dbgpConfig = DbgpConnectionConfig.load((InterpreterConfig)config);
        File file = new File(config.getScriptFilePath().toOSString());
        String ports = (String)config.getProperty("debugging_engine_server_ports");
        try {
            return new ZorbaDbgpTranslator(project, InetAddress.getByName(dbgpConfig.getHost()), dbgpConfig.getPort(), dbgpConfig.getSessionId(), file.toURI(), ports);
        }
        catch (Exception e) {
            ZorbaDebuggerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.xquery.debug.debugger.zorba", e.getMessage(), (Throwable)e));
            return null;
        }
    }
}

