/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractMessage;

public abstract class AbstractReplyMessage
extends AbstractMessage {
    private int errorCode;

    public AbstractReplyMessage(int id, int errorCode) {
        super(id);
        this.setFlags(128);
        this.errorCode = errorCode;
    }

    public byte[] toByteArray() throws IOException {
        int size = 11;
        byte[] data = this.serializeData();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outStream);
        dos.writeInt(size += data.length);
        dos.writeInt(this.getId());
        dos.writeByte(this.getFlags());
        dos.writeShort(this.errorCode);
        dos.write(data);
        return outStream.toByteArray();
    }

    public boolean equals(AbstractMessage message) {
        if (message instanceof AbstractReplyMessage) {
            AbstractReplyMessage replyMessage = (AbstractReplyMessage)message;
            if (this.getId() == replyMessage.getId() && this.getFlags() == replyMessage.getFlags() && this.getErrorCode() == replyMessage.getErrorCode() && this.isDataEqual(message)) {
                return true;
            }
        }
        return false;
    }

    public void setFlags(int flags) {
        super.setFlags(flags | 0x80);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void deserializeData(byte[] data) {
    }

    public byte[] serializeData() {
        return new byte[0];
    }
}

