/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.variables;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.wst.xquery.launching.XQDTLaunchingPlugin;
import org.eclipse.wst.xquery.set.launching.SETLaunchingPlugin;
import org.osgi.framework.Bundle;

public class CoreSdkLocationResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        String result = this.findStrategies();
        return result;
    }

    private String findStrategies() {
        String result = null;
        result = this.findShippedCoreSDK();
        if (result != null) {
            return result;
        }
        result = this.findInstalledCoreSDK();
        if (result != null) {
            return result;
        }
        return result;
    }

    private String findShippedCoreSDK() {
        String fragment;
        Bundle[] bundles;
        String os = Platform.getOS();
        String osPart = "." + os;
        String archPart = "";
        if (!os.equals("win32")) {
            archPart = "." + Platform.getOSArch();
        }
        if ((bundles = Platform.getBundles((String)(fragment = "org.eclipse.wst.xquery.set.launching" + osPart + archPart), null)) == null || bundles.length == 0) {
            if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
                CoreSdkLocationResolver.log(1, "Could not find plug-in fragment: " + fragment + ". No default Sausalito CoreSDK will be configured.", null);
            }
            return null;
        }
        if (XQDTLaunchingPlugin.DEBUG_AUTOMATIC_PROCESSOR_DETECTION) {
            CoreSdkLocationResolver.log(1, "Found Sausalito CoreSDK plug-in fragment: " + fragment, null);
        }
        Bundle bundle = bundles[0];
        URL coreSdkUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("coresdk"), null);
        try {
            coreSdkUrl = FileLocator.toFileURL((URL)coreSdkUrl);
        }
        catch (IOException ioe) {
            CoreSdkLocationResolver.log(4, "Cound not retrieve the Eclipse bundle location: " + fragment, ioe);
            return null;
        }
        Path coreSdkPath = new Path(coreSdkUrl.getPath());
        return this.locateScriptIn((IPath)coreSdkPath);
    }

    private String findInstalledCoreSDK() {
        String os = Platform.getOS();
        Path possiblePath = null;
        possiblePath = os.equals("win32") ? new Path("C:\\Program Files\\Sausalito CoreSDK 1.0.0") : new Path("/opt/sausalito");
        return this.locateScriptIn((IPath)possiblePath);
    }

    private String locateScriptIn(IPath coreSdkPath) {
        File scrptFile;
        if (coreSdkPath == null) {
            NullPointerException npe = new NullPointerException();
            CoreSdkLocationResolver.log(4, "Could not locate the Sausalito script.", npe);
            return null;
        }
        IPath scriptPath = coreSdkPath.append("bin").append("sausalito");
        if (Platform.getOS().equals("win32")) {
            scriptPath = scriptPath.addFileExtension("bat");
        }
        if (!(scrptFile = scriptPath.toFile()).exists()) {
            CoreSdkLocationResolver.log(4, "Could not find the Sausalito script at location: " + coreSdkPath.toOSString(), null);
            return null;
        }
        return scriptPath.toOSString();
    }

    public static IStatus log(int severity, String message, Throwable t) {
        Status status = new Status(severity, "org.eclipse.wst.xquery.set.launching", message, t);
        SETLaunchingPlugin.log((IStatus)status);
        return status;
    }
}

