/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.server;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerManager;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerNotStartedException;
import org.eclipse.wst.xquery.set.launching.CoreSdkUtil;
import org.eclipse.wst.xquery.set.launching.SETLaunchingPlugin;

public class Server
implements IStreamListener {
    private IProject fProject;
    private StringBuilder fErrors;
    private String fHost;
    private int fPort;
    private boolean fIndentResults;
    private boolean fClearCollections;
    private boolean fDebugMode;
    private Process fProcess;

    public Server(IProject project, String host, int port, boolean indent, boolean clear) {
        this(project, host, port, indent, clear, false);
    }

    public Server(IProject project, String host, int port, boolean indent, boolean clear, boolean debugMode) {
        this.fProject = project;
        this.fHost = host;
        this.fPort = port;
        this.fIndentResults = indent;
        this.fClearCollections = clear;
        this.fDebugMode = debugMode;
    }

    public String getHost() {
        return this.fHost;
    }

    public void setHost(String host) {
        this.fHost = host;
    }

    public String getSocketString() {
        return String.valueOf(this.fHost) + ":" + this.fPort;
    }

    public int getPort() {
        return this.fPort;
    }

    public void setPort(int port) {
        this.fPort = port;
    }

    public Process getProcess() {
        return this.fProcess;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public boolean isListening() throws ServerNotStartedException {
        if (this.fProcess == null) {
            return false;
        }
        try {
            if (this.hasErrors()) {
                Thread.sleep(300L);
                this.throwSNSE();
            }
            if (SETLaunchingPlugin.DEBUG_SERVER) {
                System.out.println("checking exit");
            }
            int error = this.fProcess.exitValue();
            if (SETLaunchingPlugin.DEBUG_SERVER) {
                System.out.println("exited with error code: " + error);
            }
            this.throwSNSE();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            if (SETLaunchingPlugin.DEBUG_SERVER) {
                System.out.println("did not exit");
            }
        }
        catch (InterruptedException interruptedException) {
            this.throwSNSE();
        }
        try {
            if (SETLaunchingPlugin.DEBUG_SERVER) {
                System.out.println("check pid");
            }
            int pid = ServerManager.getServerPid(this.fProject);
            if (SETLaunchingPlugin.DEBUG_SERVER) {
                System.out.println("pid found: " + pid);
            }
        }
        catch (DebugException debugException) {
            if (SETLaunchingPlugin.DEBUG_SERVER) {
                System.out.println("pid error");
            }
            return false;
        }
        try {
            URL testUrl = new URL("http", this.getHost(), this.getPort(), "/");
            HttpURLConnection conn = (HttpURLConnection)testUrl.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getResponseCode();
        }
        catch (ConnectException connectException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean hasErrors() {
        return this.fErrors != null;
    }

    protected Process run() throws CoreException {
        this.fErrors = null;
        String scriptPath = CoreSdkUtil.getCoreSDKScriptPath(this.fProject).toOSString();
        ArrayList<String> commandLine = new ArrayList<String>(5);
        commandLine.add(scriptPath);
        commandLine.add("test");
        commandLine.add("project");
        String path = this.fProject.getLocation().toOSString();
        commandLine.add("-d");
        commandLine.add(path);
        commandLine.add("-s");
        commandLine.add(String.valueOf(this.fHost) + ":" + this.fPort);
        if (this.fDebugMode) {
            commandLine.add("-ds");
        }
        if (this.fIndentResults) {
            commandLine.add("-i");
        }
        if (this.fClearCollections) {
            commandLine.add("-c");
        }
        this.fProcess = DebugPlugin.exec((String[])commandLine.toArray(new String[commandLine.size()]), (File)new File(path));
        return this.fProcess;
    }

    private void throwSNSE() throws ServerNotStartedException {
        int errorCode = 2;
        String errors = this.hasErrors() ? this.fErrors.toString() : "";
        String start = errors.substring(0, Math.min(30, errors.length()));
        if (start.startsWith("(OS 10048)") || start.startsWith("(48)") || start.contains("Address already in use")) {
            errorCode = 1;
        }
        throw new ServerNotStartedException(errors, errorCode);
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        if (!this.hasErrors()) {
            this.fErrors = new StringBuilder();
        }
        this.fErrors.append(text);
    }
}

