/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import org.eclipse.wst.xquery.debug.debugger.zorba.ZorbaDebuggerPlugin;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.ProtocolException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.SocketConnection;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.TransportTimeoutException;

public final class SocketClientConnection
extends SocketConnection {
    private static final byte[] handshakeBytes = "XQHandshake".getBytes();
    private int fPort;
    private int fHandshakeTimeout = 50000;
    private String fHost;

    public SocketClientConnection(int port) {
        this("127.0.0.1", port);
    }

    public SocketClientConnection(String host, int port) {
        this.fHost = host;
        this.fPort = port;
    }

    public SocketClientConnection(String host, int port, int handshakeTimeout) {
        this.fHost = host;
        this.fPort = port;
        this.fHandshakeTimeout = handshakeTimeout;
    }

    public void connect() throws IOException {
        this.fSocket = new Socket(this.fHost, this.fPort);
        this.fInput = this.fSocket.getInputStream();
        this.fOutput = this.fSocket.getOutputStream();
        this.performHandshake(this.fHandshakeTimeout);
    }

    public void performHandshake(int timeout) throws TransportTimeoutException {
        final boolean[] handshakeCompleted = new boolean[1];
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    SocketClientConnection.this.fOutput.write(handshakeBytes);
                    DataInputStream in = new DataInputStream(SocketClientConnection.this.fInput);
                    byte[] handshakeInput = new byte[handshakeBytes.length];
                    in.readFully(handshakeInput);
                    if (!Arrays.equals(handshakeInput, handshakeBytes)) {
                        throw new IOException("Received invalid handshake");
                    }
                }
                catch (IOException e) {
                    throw new ProtocolException("Protocol handshake error", e);
                }
                if (ZorbaDebuggerPlugin.DEBUG_DEBUGGER_ENGINE) {
                    System.out.println("Handshake successful");
                }
                handshakeCompleted[0] = true;
            }
        });
        t.setDaemon(true);
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException interruptedException) {}
        if (handshakeCompleted[0]) {
            return;
        }
        try {
            this.fInput.close();
            this.fOutput.close();
        }
        catch (IOException iOException) {}
        throw new TransportTimeoutException();
    }
}

