/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Preconditions;
import com.google.gson.RecursiveFieldNamingPolicy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

final class CamelCaseSeparatorNamingPolicy
extends RecursiveFieldNamingPolicy {
    private final String separatorString;

    public CamelCaseSeparatorNamingPolicy(String separatorString) {
        Preconditions.checkNotNull(separatorString);
        Preconditions.checkArgument(!"".equals(separatorString.trim()));
        this.separatorString = separatorString;
    }

    protected String translateName(String target, Type fieldType, Annotation[] annnotations) {
        StringBuilder translation = new StringBuilder();
        int i = 0;
        while (i < target.length()) {
            char character = target.charAt(i);
            if (Character.isUpperCase(character) && translation.length() != 0) {
                translation.append(this.separatorString);
            }
            translation.append(character);
            ++i;
        }
        return translation.toString();
    }
}

