/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.dbgp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.xquery.debug.dbgp.IErrorMessages;

public class ErrorMessages
implements IErrorMessages {
    private static final int NO_ERROR = 0;
    private static final int COMMAND_PARSE_ERROR = 1;
    private static final int COMMAND_DUPLICATE_ARGUMENT_ERROR = 2;
    private static final int COMMAND_INVALID_OPTION_ERROR = 3;
    private static final int COMMAND_UNIMPLEMENTED_ERROR = 4;
    private static final int COMMAND_NOT_AVAILABLE_ERROR = 5;
    private static final int FILE_CANNOT_OPEN_ERROR = 100;
    private static final int FILE_STREAM_REDIRECT_ERROR = 101;
    private static final int BREAKPOINT_SET_ERROR = 200;
    private static final int BREAKPOINT_UNSUPPORTED_TYPE_ERROR = 201;
    private static final int BREAKPOINT_INVALID_LINE_ERROR = 202;
    private static final int BREAKPOINT_LINE_NO_CODE_ERROR = 203;
    private static final int BREAKPOINT_INVALID_STATE_ERROR = 204;
    private static final int BREAKPOINT_NO_SUCH_ID_ERROR = 205;
    private static final int BREAKPOINT_EXPRESSION_EVALUATION_ERROR = 206;
    private static final int BREAKPOINT_INVALID_EXPRESSION_ERROR = 207;
    private static final int DATA_PROPERTY_ERROR = 300;
    private static final int DATA_INVALID_STACK_DEPTH_ERROR = 301;
    private static final int DATA_INVALID_CONTEXT_ERROR = 302;
    private static final int PROTOCOL_UNSUPPORTED_ENCODING_ERROR = 900;
    private static final int PROTOCOL_INTERNAL_EXCEPTION_ERROR = 998;
    private static final int PROTOCOL_UNKNOWN_ERROR = 999;
    public static Map<Integer, String> ERROR_MESSAGES = new HashMap<Integer, String>(22);

    static {
        ERROR_MESSAGES.put(0, "No error");
        ERROR_MESSAGES.put(1, "Command parse error");
        ERROR_MESSAGES.put(2, "The command has duplicate arguments");
        ERROR_MESSAGES.put(3, "the option format is not vsalid (please check if all required options are present, and all the options have valid values)");
        ERROR_MESSAGES.put(4, "Command not implemented");
        ERROR_MESSAGES.put(5, "Command not available in this state");
        ERROR_MESSAGES.put(100, "The source file could not be open");
        ERROR_MESSAGES.put(101, "Failed to redirect stream");
        ERROR_MESSAGES.put(200, "Could not set the breakpoint");
        ERROR_MESSAGES.put(201, "Unsupported breakpoint type");
        ERROR_MESSAGES.put(202, "The breakpoint location is not valid");
        ERROR_MESSAGES.put(203, "The breakpoint line contains no code");
        ERROR_MESSAGES.put(204, "The breakpoint state is not valid");
        ERROR_MESSAGES.put(205, "No breakpoint was found with the provided ID");
        ERROR_MESSAGES.put(206, "An error occurred while evaluating an eval or property-get expression");
        ERROR_MESSAGES.put(207, "A non-eval expression is invalid");
        ERROR_MESSAGES.put(300, "The requested property could not be retrieved");
        ERROR_MESSAGES.put(301, "Stack depth not valid (Cannot request a negative number of stack elements or a number greater than the actual number of avaialble stack elements. Please check the -d parameter)");
        ERROR_MESSAGES.put(302, "Context not valid (no such context exists)");
        ERROR_MESSAGES.put(900, "Unsupported encoding");
        ERROR_MESSAGES.put(998, "Internal debugger exception");
        ERROR_MESSAGES.put(999, "Unknown error");
    }

    public static String getMessage(int code) {
        return ERROR_MESSAGES.get(new Integer(code));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DbgpError {
        NO_ERROR(0),
        COMMAND_PARSE_ERROR(1),
        COMMAND_DUPLICATE_ARGUMENT_ERROR(2),
        COMMAND_INVALID_OPTION_ERROR(3),
        COMMAND_UNIMPLEMENTED_ERROR(4),
        COMMAND_NOT_AVAILABLE_ERROR(5);

        private final int fCode;

        private DbgpError(int code) {
            this.fCode = code;
        }

        public String toString() {
            return ERROR_MESSAGES.get(this.fCode);
        }
    }
}

