/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.xquery.set.internal.ui.wizards.CoreSDKTemplateUtility;
import org.eclipse.wst.xquery.set.ui.SETUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SETImportProjectWizardPage
extends WizardPage
implements IDialogFieldListener,
SelectionListener {
    protected StringButtonDialogField fDirectoryField;
    protected StringDialogField fProjectNameField;
    protected SelectionButtonDialogField fUseDefaultInterpreterField;
    protected SelectionButtonDialogField fUseProjectInterpreterField;
    protected ComboDialogField fInterpreterCombo;
    protected Link fPreferenceLink;
    protected Button fCopyButton;
    private String fInitialProjectName;
    private IInterpreterInstall[] fInstalledInterpreters;
    private String[] fComplianceLabels;
    private final IProject[] fProjects;
    private boolean fInterpretersPresent;

    protected SETImportProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Import a Sausalito project from the local file system into the workspace");
        this.fProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.fDirectoryField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                File dir = SETImportProjectWizardPage.this.browseForDirectory();
                if (dir != null) {
                    SETImportProjectWizardPage.this.fDirectoryField.setText(dir.getPath());
                }
            }
        });
        this.fDirectoryField.setLabelText("Select Directory:");
        this.fDirectoryField.setButtonLabel("Browse...");
        this.fDirectoryField.doFillIntoGrid(composite, 3);
        this.fDirectoryField.getTextControl(null).setLayoutData((Object)new GridData(768));
        this.fProjectNameField = new StringDialogField();
        this.fProjectNameField.setLabelText("Project name:");
        this.fProjectNameField.doFillIntoGrid(composite, 3);
        this.createVerticalSpacer(composite);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        group.setText("Sausalito CoreSDK");
        this.createVerticalSpacer((Composite)group);
        this.fUseDefaultInterpreterField = new SelectionButtonDialogField(16);
        this.fUseDefaultInterpreterField.setLabelText(this.getDefaultInterpreterLabel());
        this.fUseDefaultInterpreterField.doFillIntoGrid((Composite)group, 2);
        this.fPreferenceLink = new Link((Composite)group, 0);
        this.fPreferenceLink.setFont(group.getFont());
        this.fPreferenceLink.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_link_description);
        this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
        this.createVerticalSpacer((Composite)group);
        this.fUseProjectInterpreterField = new SelectionButtonDialogField(16);
        this.fUseProjectInterpreterField.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_specific_compliance);
        this.fUseProjectInterpreterField.doFillIntoGrid((Composite)group, 1);
        this.fInterpreterCombo = new ComboDialogField(8);
        this.fillInstalledInterpreters(this.fInterpreterCombo);
        Combo comboControl = this.fInterpreterCombo.getComboControl((Composite)group);
        GridData gridData = new GridData(1, 2, true, false);
        gridData.minimumWidth = 100;
        comboControl.setLayoutData((Object)gridData);
        comboControl.setVisibleItemCount(20);
        this.createVerticalSpacer(composite);
        this.fCopyButton = new Button(composite, 32);
        this.fCopyButton.setText("Copy project into workspace");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fCopyButton.setLayoutData((Object)gd);
        this.fUseDefaultInterpreterField.setSelection(true);
        this.fInterpreterCombo.setEnabled(this.fUseProjectInterpreterField.isSelected());
        this.addFieldListeners();
        this.setPageComplete(this.isValid());
        this.setControl((Control)composite);
    }

    protected void createVerticalSpacer(Composite parent) {
        GridData gd = new GridData(0);
        gd.horizontalSpan = 3;
        gd.heightHint = 0;
        Label l = new Label(parent, 16384);
        l.setLayoutData((Object)gd);
    }

    private File browseForDirectory() {
        String dir;
        String startDirectory = this.fDirectoryField.getText().trim();
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 4096);
        if (startDirectory != null) {
            fileDialog.setFilterPath(startDirectory);
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    private String getDefaultInterpreterLabel() {
        String name = null;
        IInterpreterInstall inst = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry("org.eclipse.wst.xquery.set.core.nature", EnvironmentManager.getLocalEnvironment().getId()));
        name = inst != null ? inst.getName() : "undefined";
        return "Use def&ault interpreter (Currently ''" + name + "'')";
    }

    private void addFieldListeners() {
        this.fDirectoryField.setDialogFieldListener((IDialogFieldListener)this);
        this.fProjectNameField.setDialogFieldListener((IDialogFieldListener)this);
        this.fUseDefaultInterpreterField.setDialogFieldListener((IDialogFieldListener)this);
        this.fUseProjectInterpreterField.setDialogFieldListener((IDialogFieldListener)this);
        this.fInterpreterCombo.setDialogFieldListener((IDialogFieldListener)this);
        this.fPreferenceLink.addSelectionListener((SelectionListener)this);
    }

    public void setProjectName(String value) {
        if (this.fInitialProjectName == null) {
            this.fInitialProjectName = value;
        }
    }

    public void dialogFieldChanged(DialogField field) {
        if (field == this.fDirectoryField) {
            IPath path = this.getImportPath();
            if (path.segmentCount() == 0) {
                this.fProjectNameField.setText("");
            } else {
                if (path.removeLastSegments(1).equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
                    this.fCopyButton.setEnabled(false);
                } else {
                    this.fCopyButton.setEnabled(true);
                }
                this.fProjectNameField.setText(path.lastSegment());
            }
            return;
        }
        if (field == this.fUseProjectInterpreterField) {
            this.fInterpreterCombo.setEnabled(this.fUseProjectInterpreterField.isSelected());
        }
        this.setPageComplete(this.isValid());
    }

    private boolean isValid() {
        IPath dir = this.getImportPath();
        String projectName = this.getProjectName();
        if (!this.fInterpretersPresent) {
            this.setErrorMessage("At least one Sausalito CoreSDK installation must be configured");
            return false;
        }
        String importDir = this.fDirectoryField.getText().trim();
        if (importDir.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage("Select a project directory from your local file system to import into the workspace");
            return false;
        }
        File file = new File(importDir);
        if (!file.exists() || !file.isDirectory()) {
            this.setErrorMessage("Invalid directory: " + importDir);
            return false;
        }
        IProject[] iProjectArray = this.fProjects;
        int n = this.fProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().equals((Object)dir)) {
                this.setErrorMessage("The given path corresponds to a project that is already in the workspace");
                return false;
            }
            if (project.getName().equals(projectName)) {
                this.setErrorMessage("A project with this name already exists in the workspace");
                return false;
            }
            ++n2;
        }
        file = new File(String.valueOf(importDir) + File.separator + ".project");
        if (file.exists() && !file.isDirectory()) {
            this.setErrorMessage("The indicated path already contains an eclipse project. Use the \"Existing Projects into Workspace\" import wizard.");
            return false;
        }
        file = new File(String.valueOf(importDir) + File.separator + ".config" + File.separator + "sausalito.xml");
        if (!file.exists() || file.isDirectory()) {
            this.setErrorMessage("\"" + importDir + "\" is not a valid Sausalito project");
            return false;
        }
        if (projectName.length() == 0) {
            this.setErrorMessage("Project name cannot be empty");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private String getProjectName() {
        return this.fProjectNameField.getText().trim();
    }

    private IPath getImportPath() {
        return new Path(this.fDirectoryField.getText());
    }

    private boolean isCopyProject() {
        return this.fCopyButton.isEnabled() && this.fCopyButton.getSelection();
    }

    public IInterpreterInstall getSelectedInterpreter() {
        int index;
        if (this.fUseProjectInterpreterField.isSelected() && (index = this.fInterpreterCombo.getSelectionIndex()) >= 0 && index < this.fComplianceLabels.length) {
            return this.fInstalledInterpreters[index];
        }
        return null;
    }

    public boolean finishPage() {
        final ImportProjectRecord projectRecord = new ImportProjectRecord(this.getProjectName(), this.getImportPath(), this.isCopyProject(), this.getSelectedInterpreter());
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    try {
                        int ticks = projectRecord.isCopy ? 4000 : 900;
                        monitor.beginTask("", ticks);
                        if (!SETImportProjectWizardPage.this.createProject(projectRecord, monitor)) {
                            SETImportProjectWizardPage.this.rollbackCreateProject(projectRecord);
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.setTaskName("Canceling project import...");
                        SETImportProjectWizardPage.this.rollbackCreateProject(projectRecord);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.reportError(t);
            return false;
        }
        return true;
    }

    private boolean createProject(ImportProjectRecord projectRecord, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        File[] children;
        this.checkMonitor(monitor);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectRecord.projectName);
        File importDir = projectRecord.importPath.toFile();
        URI location = null;
        location = projectRecord.isCopy ? root.getLocationURI() : importDir.toURI();
        monitor.setTaskName("Creating the project...");
        BuildpathsBlock.createProject((IProject)project, (URI)location, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        this.checkMonitor(monitor);
        monitor.setTaskName("Configuring Sausalito project...");
        BuildpathsBlock.addScriptNature((IProject)project, (IProgressMonitor)new SubProgressMonitor(monitor, 300), (String)"org.eclipse.wst.xquery.set.core.nature");
        this.checkMonitor(monitor);
        IPath projectPath = project.getFullPath();
        IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();
        String handlerSrcPath = store.getString("org.eclipse.wst.xquery.set.preferences.buildpath.handler");
        String libSrcPath = store.getString("org.eclipse.wst.xquery.set.preferences.buildpath.library");
        String externalSrcPath = store.getString("org.eclipse.wst.xquery.set.preferences.buildpath.external");
        Object[] srcDirs = new String[]{externalSrcPath, handlerSrcPath, libSrcPath};
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>();
        File[] fileArray = children = importDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (Arrays.binarySearch(srcDirs, child.getName()) >= 0) {
                entries.add(DLTKCore.newSourceEntry((IPath)projectPath.append(child.getName())));
            }
            ++n2;
        }
        IInterpreterInstall install = projectRecord.interpreterInstall;
        IBuildpathEntry interpreterEntry = null;
        interpreterEntry = install == null ? ScriptRuntime.getDefaultInterpreterContainerEntry() : this.getInterpreterBuildpathEntry(install);
        if (interpreterEntry != null) {
            entries.add(interpreterEntry);
        }
        if (projectRecord.isCopy) {
            monitor.setTaskName("Copying project contents...");
            CoreSDKTemplateUtility.createProjectContent(project, projectRecord.importPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3000));
            this.checkMonitor(monitor);
        }
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        monitor.setTaskName("Setting project interpreter...");
        BuildpathsBlock.flush(this.getBPEntries(scriptProject, entries), (IScriptProject)scriptProject, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        return true;
    }

    private void rollbackCreateProject(ImportProjectRecord projectRecord) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectRecord.projectName);
        if (project.exists()) {
            project.delete(true, true, null);
        }
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private ArrayList<BPListElement> getBPEntries(IScriptProject project, List<IBuildpathEntry> buildpathEntries) {
        ArrayList<BPListElement> newBuildpath = new ArrayList<BPListElement>();
        for (IBuildpathEntry entry : buildpathEntries) {
            newBuildpath.add(BPListElement.createFromExisting((IBuildpathEntry)entry, (IScriptProject)project));
        }
        return newBuildpath;
    }

    private void reportError(Throwable t) {
        String message = "Import problems";
        Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.wst.xquery.org.set.ui", 1, message, t);
        ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.showInterpreterPreferencePage();
        this.refreshInterpretes();
        this.updateEnableState();
    }

    public void widgetSelected(SelectionEvent e) {
        this.widgetDefaultSelected(e);
    }

    private void showInterpreterPreferencePage() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.wst.xquery.set.preferences.interpreters", (String[])new String[]{"org.eclipse.wst.xquery.set.preferences.interpreters"}, null).open();
    }

    private void refreshInterpretes() {
        this.fUseDefaultInterpreterField.setLabelText(this.getDefaultInterpreterLabel());
        this.fillInstalledInterpreters(this.fInterpreterCombo);
    }

    private void updateEnableState() {
        this.fInterpreterCombo.setEnabled(this.fUseProjectInterpreterField.isSelected());
    }

    private void fillInstalledInterpreters(ComboDialogField comboField) {
        String selectedItem = null;
        int selectionIndex = -1;
        if (this.fUseProjectInterpreterField.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
            selectedItem = comboField.getItems()[selectionIndex];
        }
        this.fInstalledInterpreters = this.getWorkspaceInterpeters();
        selectionIndex = -1;
        this.fComplianceLabels = new String[this.fInstalledInterpreters.length];
        int i = 0;
        while (i < this.fInstalledInterpreters.length) {
            this.fComplianceLabels[i] = this.fInstalledInterpreters[i].getName();
            if (selectedItem != null && this.fComplianceLabels[i].equals(selectedItem)) {
                selectionIndex = i;
            }
            ++i;
        }
        comboField.setItems(this.fComplianceLabels);
        if (selectionIndex == -1) {
            this.fInterpreterCombo.selectItem(this.getDefaultInterpreterName());
        } else {
            this.fInterpreterCombo.selectItem(selectedItem);
        }
        this.fInterpretersPresent = this.fInstalledInterpreters.length > 0;
        this.setPageComplete(this.isValid());
    }

    private IInterpreterInstall[] getWorkspaceInterpeters() {
        ArrayList<InterpreterStandin> standins = new ArrayList<InterpreterStandin>();
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)"org.eclipse.wst.xquery.set.core.nature");
        int i = 0;
        while (i < types.length) {
            IInterpreterInstallType type = types[i];
            IInterpreterInstall[] installs = type.getInterpreterInstalls();
            int j = 0;
            while (j < installs.length) {
                standins.add(new InterpreterStandin(installs[j]));
                ++j;
            }
            ++i;
        }
        return standins.toArray(new IInterpreterInstall[standins.size()]);
    }

    private String getDefaultInterpreterName() {
        IInterpreterInstall inst = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry("org.eclipse.wst.xquery.set.core.nature", EnvironmentManager.getLocalEnvironment().getId()));
        if (inst != null) {
            return inst.getName();
        }
        return "undefined";
    }

    private IBuildpathEntry getInterpreterBuildpathEntry(IInterpreterInstall install) {
        IBuildpathEntry defaultPath = ScriptRuntime.getDefaultInterpreterContainerEntry();
        Path InterpreterEnvironmentContainerPath = new Path(ScriptRuntime.INTERPRETER_CONTAINER);
        if (install != null) {
            IPath newPath = InterpreterEnvironmentContainerPath.append(install.getInterpreterInstallType().getId()).append(install.getName());
            return DLTKCore.newContainerEntry((IPath)newPath);
        }
        return defaultPath;
    }

    private static class ImportProjectRecord {
        protected boolean isCopy;
        protected String projectName;
        protected IPath importPath;
        protected IInterpreterInstall interpreterInstall;

        public ImportProjectRecord(String name, IPath path, boolean copy, IInterpreterInstall install) {
            this.projectName = name;
            this.importPath = path;
            this.isCopy = copy;
            this.interpreterInstall = install;
        }
    }
}

