/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.environment;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentProvider;
import org.eclipse.wst.xquery.internal.core.environment.RemoteEnvironment;

public class RemoteEnvironmentProvider
implements IEnvironmentProvider {
    public static final String[] FILE_SCHEMES = new String[]{"http", "https"};

    public static boolean supportsScheme(String scheme) {
        return scheme != null && Arrays.binarySearch(FILE_SCHEMES, scheme) >= 0;
    }

    public IEnvironment getEnvironment(String envId) {
        if ("org.eclipse.wst.xquery.core.environment.remoteEnvironment".equals(envId)) {
            return RemoteEnvironment.getInstance();
        }
        return null;
    }

    public IEnvironment getEnvironment(URI locationURI) {
        if (RemoteEnvironmentProvider.supportsScheme(locationURI.getScheme())) {
            return RemoteEnvironment.getInstance();
        }
        return null;
    }

    public IEnvironment[] getEnvironments() {
        return new IEnvironment[]{RemoteEnvironment.getInstance()};
    }

    public IEnvironment getProjectEnvironment(IProject project) {
        File file;
        IPath location;
        if (project.isAccessible() && (location = project.getLocation()) != null && (file = new File(location.makeAbsolute().toOSString())).exists()) {
            return RemoteEnvironment.getInstance();
        }
        return null;
    }

    public String getProviderName() {
        return "Remote";
    }

    public boolean isInitialized() {
        return true;
    }

    public void waitInitialized() {
    }
}

