/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.parser.visitors;

import java.util.Stack;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.wst.xquery.core.model.ast.IChildProcessor;
import org.eclipse.wst.xquery.core.model.ast.XQueryBaseURIDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryFunctionDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryMainModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryModuleDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryModuleImport;
import org.eclipse.wst.xquery.core.model.ast.XQueryParam;
import org.eclipse.wst.xquery.core.model.ast.XQueryQueryBody;
import org.eclipse.wst.xquery.core.model.ast.XQueryStringLiteral;
import org.eclipse.wst.xquery.core.model.ast.XQueryVarDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryXmlAttributeValueText;
import org.eclipse.wst.xquery.core.model.ast.XQueryXmlElementContentText;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQDTCommonTree;
import org.eclipse.wst.xquery.internal.core.parser.visitors.NodeVisitor;

public class XQDTCommonTreeVisitor
implements NodeVisitor {
    private char[] fContent;
    private XQueryModule fModule = null;
    private Stack<ASTNode> fStack = new Stack();

    public XQDTCommonTreeVisitor(char[] content, IProblemReporter reporter) {
        this.fContent = content;
    }

    public char[] getContent() {
        return this.fContent;
    }

    public ModuleDeclaration getModule() {
        return this.fModule;
    }

    public void beginVisit(CommonTree tree) {
        try {
            XQDTCommonTree xct = (XQDTCommonTree)tree;
            XQDTCommonTree child0 = null;
            XQDTCommonTree child1 = null;
            StringBuffer sb = null;
            String type = null;
            String qn = null;
            String str = null;
            switch (tree.getType()) {
                case 255: {
                    this.fModule = new XQueryLibraryModule(this.fContent.length);
                    this.push(xct, (ASTNode)this.fModule);
                    break;
                }
                case 256: {
                    this.fModule = new XQueryMainModule(this.fContent.length);
                    this.push(xct, (ASTNode)this.fModule);
                    break;
                }
                case 257: {
                    this.fModule.setVersion(tree.getChild(0).getChild(0).getText());
                    if (tree.getChildCount() == 6) {
                        this.fModule.setEncoding(tree.getChild(1).getChild(0).getText());
                    }
                    break;
                }
                case 260: {
                    XQueryModuleDecl modDecl = new XQueryModuleDecl(xct.getStart(), xct.getStop() + 1);
                    if (xct.getChild(0).getType() == 238) {
                        modDecl.setNamespacePrefix(xct.getChild(0).getText());
                    }
                    this.push(xct, (ASTNode)modDecl);
                    break;
                }
                case 274: {
                    if (xct.getChild(0).getType() == 271 || xct.getChild(0).getChildCount() != 0) {
                        child0 = xct.getChild(0).getChild(0);
                        XQueryModuleImport imp = new XQueryModuleImport(child0.getText(), child0.getStart(), child0.getStop() + 1, xct.getStart(), xct.getStop() + 1);
                        this.push(xct, (ASTNode)imp);
                    }
                    break;
                }
                case 275: {
                    this.push(xct, (ASTNode)new XQueryBaseURIDecl(xct.getStart(), xct.getStop() + 1));
                    break;
                }
                case 277: {
                    boolean isConstant;
                    if (xct.getChildCount() < 4) break;
                    if (xct.getChild(0).getType() == 282) {
                        isConstant = false;
                    } else {
                        if (xct.getChild(0).getType() != 281) break;
                        isConstant = true;
                    }
                    boolean isExternal = false;
                    if (xct.getChild(3).getType() == 279) {
                        if (xct.getChild(3).getType() == 280) {
                            isExternal = true;
                        }
                        if ((child0 = xct.getChild(1)).getType() == 305) {
                            qn = this.readQNameString(child0);
                            XQueryVarDecl varDecl = new XQueryVarDecl(qn, child0.getStart(), child0.getStop() + 1, xct.getStart(), xct.getStop() + 1, isExternal, isConstant);
                            if (xct.getChild(2).getChildCount() == 1) {
                                child1 = xct.getChild(2).getChild(0);
                                type = this.readSequenceTypeString(child1.getChild(0));
                                varDecl.setType(type);
                            }
                            this.push(xct, (ASTNode)varDecl);
                        }
                    }
                    break;
                }
                case 283: {
                    child0 = xct.getChild(0);
                    str = this.readFunctionQNameString(child0);
                    if (str != null) {
                        if (tree.getChild(2).getChildCount() == 1) {
                            type = this.readSequenceTypeString(xct.getChild(2).getChild(0).getChild(0));
                        }
                        boolean isExternalFun = tree.getChildCount() == 3;
                        int indexOfColon = str.indexOf(58);
                        this.push(xct, (ASTNode)new XQueryFunctionDecl(str.substring(0, indexOfColon), str.substring(indexOfColon + 1), child0.getStart(), child0.getStop() + 1, xct.getStart(), xct.getStop() + 1, type, isExternalFun));
                    }
                    break;
                }
                case 288: {
                    child0 = xct.getChild(0);
                    qn = this.readQNameString(child0);
                    if (qn != null) {
                        if (xct.getChildCount() == 2) {
                            child1 = xct.getChild(1).getChild(0);
                            type = this.readSequenceTypeString(child1);
                        }
                        XQueryFunctionDecl fun = (XQueryFunctionDecl)((Object)this.fStack.lastElement());
                        fun.addArgument(new XQueryParam(new SimpleReference(child0.getStart(), child0.getStop() + 1, qn), child0.getStart(), type));
                    }
                    break;
                }
                case 290: {
                    this.push(xct, (ASTNode)new XQueryQueryBody(xct.getStart(), xct.getStop() + 1));
                    break;
                }
                case 292: {
                    child1 = xct.getChild(1);
                    int i = 0;
                    while (i < child1.getChildCount()) {
                        child0 = child1.getChild(i);
                        if (child0.getType() == 303 || child0.getType() == 296) {
                            this.fModule.addXmlElementContents(new XQueryXmlElementContentText(child0.getStart(), child0.getStop(), child0.getChild(0).getText()));
                        }
                        ++i;
                    }
                    break;
                }
                case 294: {
                    if (xct.getChildCount() != 0) {
                        int i = 0;
                        while (i < xct.getChildCount()) {
                            child0 = xct.getChild(i);
                            if (child0.getType() == 304 || child0.getType() == 296) {
                                this.fModule.addXmlAttributeValuesText(new XQueryXmlAttributeValueText(child0.getStart(), child0.getStop(), child0.getChild(0).getText()));
                            }
                            ++i;
                        }
                    }
                    break;
                }
                case 296: {
                    break;
                }
                case 302: {
                    sb = new StringBuffer();
                    if (xct.getChildCount() > 0) {
                        for (Object child : xct.getChildren()) {
                            sb.append(child.toString());
                        }
                    }
                    this.push(xct, (ASTNode)new XQueryStringLiteral(xct.getStart(), xct.getStop(), sb.toString()));
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Unhandeled visitor exception");
        }
    }

    private String readFunctionQNameString(XQDTCommonTree node) {
        String qname = this.readQNameString(node);
        if (qname == null) {
            return null;
        }
        if (qname.indexOf(58) == -1) {
            return "local:" + qname;
        }
        return qname;
    }

    private String readQNameString(XQDTCommonTree node) {
        if (node == null || node.getType() != 305) {
            return null;
        }
        if (node.getChildCount() == 1) {
            return node.getChild(0).getText();
        }
        if (node.getChildCount() == 3) {
            return String.valueOf(node.getChild(0).getText()) + ":" + node.getChild(2).getText();
        }
        return null;
    }

    private String readSequenceTypeString(XQDTCommonTree node) {
        String type;
        if (node == null || node.getChildCount() == 0) {
            return null;
        }
        XQDTCommonTree child = node.getChild(0);
        switch (child.getType()) {
            case 301: {
                type = this.readQNameString(child.getChild(0));
                if (type != null) break;
                return null;
            }
            case 298: 
            case 299: 
            case 300: {
                StringBuilder strb = new StringBuilder();
                int i = 0;
                while (i < child.getChildCount()) {
                    strb.append((Object)child.getChild(i));
                    ++i;
                }
                type = strb.toString();
                break;
            }
            default: {
                return null;
            }
        }
        if (node.getChildCount() == 2) {
            type = String.valueOf(type) + node.getChild(1).getText();
        }
        return type;
    }

    public void endVisit(CommonTree tree) {
        XQDTCommonTree xct = (XQDTCommonTree)tree;
        ASTNode currentNode = null;
        ASTNode parentNode = null;
        switch (tree.getType()) {
            case 255: {
                this.fModule = (XQueryModule)this.fStack.pop();
                break;
            }
            case 256: {
                this.fModule = (XQueryModule)this.fStack.pop();
                break;
            }
            case 260: {
                currentNode = this.pop(xct);
                if (currentNode == null || !((parentNode = this.fStack.peek()) instanceof IChildProcessor)) break;
                ((IChildProcessor)parentNode).processChild(currentNode);
                break;
            }
            case 257: {
                break;
            }
            case 274: {
                currentNode = this.pop(xct);
                if (currentNode == null || !((parentNode = this.fStack.peek()) instanceof IChildProcessor)) break;
                ((IChildProcessor)parentNode).processChild(currentNode);
                break;
            }
            case 275: {
                currentNode = this.pop(xct);
                if (currentNode == null || !((parentNode = this.fStack.peek()) instanceof IChildProcessor)) break;
                ((IChildProcessor)parentNode).processChild(currentNode);
                break;
            }
            case 277: {
                currentNode = this.pop(xct);
                if (currentNode == null || !((parentNode = this.fStack.peek()) instanceof IChildProcessor)) break;
                ((IChildProcessor)parentNode).processChild(currentNode);
                break;
            }
            case 283: {
                currentNode = this.pop(xct);
                if (currentNode == null || !((parentNode = this.fStack.peek()) instanceof IChildProcessor)) break;
                ((IChildProcessor)parentNode).processChild(currentNode);
                break;
            }
            case 288: {
                break;
            }
            case 290: {
                currentNode = this.pop(xct);
                if (currentNode == null || !((parentNode = this.fStack.peek()) instanceof IChildProcessor)) break;
                ((IChildProcessor)parentNode).processChild(currentNode);
                break;
            }
            case 292: {
                break;
            }
            case 294: {
                break;
            }
            case 296: {
                break;
            }
            case 302: {
                currentNode = this.pop(xct);
                if (currentNode == null) break;
                parentNode = this.fStack.peek();
                if (parentNode instanceof IChildProcessor) {
                    ((IChildProcessor)parentNode).processChild(currentNode);
                }
                this.fModule.addStringLiteral((XQueryStringLiteral)currentNode);
                break;
            }
        }
    }

    private void push(XQDTCommonTree tree, ASTNode node) {
        this.fStack.push(node);
        tree.setStacked(true);
    }

    private ASTNode pop(XQDTCommonTree tree) {
        if (!tree.isStacked()) {
            return null;
        }
        tree.setStacked(false);
        return this.fStack.pop();
    }
}

