/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.zorba;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.wst.xquery.internal.launching.zorba.ZorbaInstall;
import org.eclipse.wst.xquery.launching.XQDTInterpreterInstallType;
import org.eclipse.wst.xquery.launching.zorba.ZorbaLaunchingPlugin;

public class ZorbaInstallType
extends XQDTInterpreterInstallType {
    public static final String INSTALL_TYPE_ID = "org.eclipse.wst.xquery.launching.ZorbaInstallType";
    private static final String INSTALL_TYPE_NAME = "Zorba XQuery Engine";

    public String getName() {
        return INSTALL_TYPE_NAME;
    }

    public String getId() {
        return INSTALL_TYPE_ID;
    }

    protected String[] getPossibleInterpreterNames() {
        return new String[]{"zorba"};
    }

    protected IInterpreterInstall doCreateInterpreterInstall(String id) {
        return new ZorbaInstall((IInterpreterInstallType)this, id);
    }

    public IEnvironment getEnvironment() {
        return EnvironmentManager.getLocalEnvironment();
    }

    public String getResolverFacetId() {
        return "zorbaUriResolver";
    }

    protected IPath createPathFile(IDeployment deployment) throws IOException {
        return deployment.add(ZorbaLaunchingPlugin.getDefault().getBundle(), "Resources/scripts/path.xq");
    }

    protected String[] buildCommandLine(IFileHandle installLocation, IFileHandle pathFile) {
        String interpreterPath = installLocation.getCanonicalPath();
        String scriptPath = pathFile.getCanonicalPath();
        String zorbaRoot = installLocation.getParent().getParent().getCanonicalPath();
        return new String[]{interpreterPath, "-r", "-f", "-q", scriptPath, "-e", "zorbaRoot:=" + zorbaRoot};
    }
}

