/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.launching.zorba;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.wst.xquery.launching.xqdoc.AbstractXQDocRuntime;
import org.eclipse.wst.xquery.launching.zorba.ZorbaLaunchingPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZorbaXQDocRuntime
extends AbstractXQDocRuntime {
    private static final String XQDOC_RESOUCES_PATH = "Resources/xqDoc";
    private static final String XQDOC_MAIN_QUERY_PATH = "src/xqdoc.xq";
    private static final String XQDOC_STYLES_PATH = "styles";

    public ZorbaXQDocRuntime(IScriptProject project, IProgressMonitor monitor) {
        super(project, monitor);
    }

    public void generateXQDoc() throws Exception {
        IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.fProject);
        if (install == null) {
            return;
        }
        File dir = new File(this.fFolder.toOSString());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Path bundlePath = new Path(FileLocator.getBundleFile((Bundle)ZorbaLaunchingPlugin.getDefault().getBundle()).getAbsolutePath());
        IPath xqdocResourcesPath = bundlePath.append(XQDOC_RESOUCES_PATH);
        IPath mainQueryPath = xqdocResourcesPath.append(XQDOC_MAIN_QUERY_PATH);
        IPath stylesheetPath = xqdocResourcesPath.append(XQDOC_STYLES_PATH).append(this.fStylesheet);
        this.fMonitor.beginTask("Copy stylesheet", 1);
        AbstractXQDocRuntime.FileCopy.copy((String)stylesheetPath.toOSString(), (String)(String.valueOf(this.fFolder.toOSString()) + "/" + this.fStylesheet));
        this.fMonitor.worked(1);
        this.fMonitor.beginTask("Generating documentation", this.fQueries.size());
        for (IPath query : this.fQueries) {
            String pline;
            String queryFileName = query.lastSegment();
            this.fMonitor.setTaskName("Generating documentation for " + queryFileName);
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.add(install.getInstallLocation().getPath().toOSString());
            cmdLine.add("-q");
            cmdLine.add(mainQueryPath.toOSString());
            cmdLine.add("-f");
            cmdLine.add("-e");
            cmdLine.add("modulePath:=" + query.toOSString());
            cmdLine.add("-e");
            cmdLine.add("stylesheet:=" + this.fStylesheet);
            IExecutionEnvironment exeEnv = install.getExecEnvironment();
            EnvironmentVariable[] environmentVariables = install.getEnvironmentVariables();
            String[] vars = null;
            if (environmentVariables != null && environmentVariables.length > 0) {
                vars = new String[environmentVariables.length];
                int j = 0;
                while (j < environmentVariables.length) {
                    vars[j] = environmentVariables[j].toString();
                    ++j;
                }
            }
            Process p = exeEnv.exec(cmdLine.toArray(new String[cmdLine.size()]), null, vars);
            InputStream in = p.getInputStream();
            String outputFileName = String.valueOf(this.fFolder.toOSString()) + "/" + queryFileName.substring(0, queryFileName.lastIndexOf(46)) + ".html";
            File outputFile = new File(outputFileName);
            outputFile.createNewFile();
            BufferedWriter output = new BufferedWriter(new FileWriter(outputFile));
            BufferedReader pin = new BufferedReader(new InputStreamReader(in));
            while ((pline = pin.readLine()) != null) {
                output.write(pline);
            }
            in.close();
            pin = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((pline = pin.readLine()) != null) {
                System.err.println(pline);
            }
            output.close();
            p.waitFor();
            this.fMonitor.worked(1);
        }
    }

    public void init(Collection<IPath> queries, IPath destination, String stylesheet) {
        for (IPath path : queries) {
            this.fQueries.add(path);
        }
        this.fFolder = destination;
        this.fStylesheet = stylesheet;
    }
}

