/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc;

import java.math.BigInteger;
import java.util.Locale;
import org.eclipse.wst.xquery.marklogic.xcc.ContentPermission;
import org.eclipse.wst.xquery.marklogic.xcc.DocumentFormat;
import org.eclipse.wst.xquery.marklogic.xcc.DocumentRepairLevel;

public class ContentCreateOptions {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int MIN_BUFFER_SIZE = 256;
    public static final int MAX_BUFFER_SIZE = 0xC00000;
    private DocumentFormat format = DocumentFormat.NONE;
    private DocumentRepairLevel repairLevel = DocumentRepairLevel.DEFAULT;
    private Locale locale = null;
    private boolean resolveEntities = false;
    private int resolveBufferSize = 0;
    private ContentPermission[] permissions = null;
    private String[] collections = null;
    private int quality = 0;
    private String namespace = null;
    private BigInteger[] placeKeys = null;
    private String language = null;
    private String encoding = "UTF-8";
    private int bufferSize = -1;

    public static ContentCreateOptions newXmlInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatXml();
        return options;
    }

    public static ContentCreateOptions newTextInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatText();
        return options;
    }

    public static ContentCreateOptions newBinaryInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatBinary();
        return options;
    }

    public void setFormat(DocumentFormat format) {
        this.format = format;
    }

    public DocumentFormat getFormat() {
        return this.format;
    }

    public void setFormatXml() {
        this.setFormat(DocumentFormat.XML);
    }

    public void setFormatText() {
        this.setFormat(DocumentFormat.TEXT);
    }

    public void setFormatBinary() {
        this.setFormat(DocumentFormat.BINARY);
    }

    public DocumentRepairLevel getRepairLevel() {
        return this.repairLevel;
    }

    public void setRepairLevel(DocumentRepairLevel repairLevel) {
        this.repairLevel = repairLevel;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean getResolveEntities() {
        return this.resolveEntities;
    }

    public void setResolveEntities(boolean resolveEntities) {
        this.resolveEntities = resolveEntities;
    }

    public int getResolveBufferSize() {
        return this.resolveBufferSize;
    }

    public void setResolveBufferSize(int resolveBufferSize) {
        this.resolveBufferSize = resolveBufferSize;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    public String[] getCollections() {
        return this.collections == null ? null : (String[])this.collections.clone();
    }

    public void setCollections(String[] collections) {
        this.collections = collections == null ? null : (String[])collections.clone();
    }

    public BigInteger[] getPlaceKeys() {
        return this.placeKeys == null ? null : (BigInteger[])this.placeKeys.clone();
    }

    public void setPlaceKeys(BigInteger[] forestKeys) {
        this.placeKeys = forestKeys == null ? null : (BigInteger[])forestKeys.clone();
    }

    public void setPlaceKeys(long[] forestKeys) {
        if (forestKeys == null) {
            this.placeKeys = null;
            return;
        }
        BigInteger[] bigInts = new BigInteger[forestKeys.length];
        int i = 0;
        while (i < forestKeys.length) {
            bigInts[i] = new BigInteger("" + forestKeys[i]);
            ++i;
        }
        this.setPlaceKeys(bigInts);
    }

    public ContentPermission[] getPermissions() {
        return this.permissions == null ? null : (ContentPermission[])this.permissions.clone();
    }

    public void setPermissions(ContentPermission[] permissions) {
        this.permissions = permissions == null ? null : (ContentPermission[])permissions.clone();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int newSize) {
        this.bufferSize = newSize < 1 ? -1 : (newSize < 256 ? 256 : (newSize > 0xC00000 ? 0xC00000 : newSize));
    }
}

