/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl.handlers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.http.HttpChannel;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestPermissionException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestServerException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RetryableXQueryException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.ServerConnectionException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SessionImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.HttpRequestController;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ResponseHandler;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionErrorAction;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestController
implements HttpRequestController {
    protected final Map<Integer, ResponseHandler> handlers;
    protected static final Integer DEFAULT_HANDLER_KEY = new Integer(0);
    public static boolean dontSleep = false;

    protected AbstractRequestController(Map<Integer, ResponseHandler> handlers) {
        this.handlers = handlers == null ? new HashMap<Integer, ResponseHandler>() : handlers;
    }

    public abstract ResultSequence serverDialog(ServerConnection var1, Request var2, RequestOptions var3, Logger var4) throws IOException, RequestException;

    @Override
    public ResultSequence runRequest(ConnectionProvider provider, Request request, Logger logger) throws RequestException {
        Session session = request.getSession();
        RequestOptions options = request.getEffectiveOptions();
        long delayMillis = options.getAutoRetryDelayMillis();
        int retries = options.getMaxAutoRetry();
        int tries = Math.max(retries + 1, 1);
        RequestException re = null;
        logger.fine("submitting request, max tries=" + tries);
        int t = 0;
        while (t < tries) {
            block14: {
                ServerConnection connection = null;
                this.sleepFor(this.interTryDelay(delayMillis, t));
                try {
                    while (true) {
                        connection = provider.obtainConnection(session, request, logger);
                        try {
                            ResultSequence rs = this.serverDialog(connection, request, options, logger);
                            if (rs == null || rs.isCached()) {
                                provider.returnConnection(connection, logger);
                            }
                            return rs;
                        }
                        catch (RequestPermissionException e) {
                            if (e.isRetryAdvised()) {
                                provider.returnConnection(connection, logger);
                                continue;
                            }
                            throw e;
                        }
                        break;
                    }
                }
                catch (RetryableXQueryException e) {
                    logger.fine("retryable server exception caught: " + e);
                    provider.returnConnection(connection, logger);
                    re = e;
                }
                catch (RequestServerException e) {
                    logger.fine("non-retryable server exception caught: " + e);
                    provider.returnConnection(connection, logger);
                    throw e;
                }
                catch (IOException e) {
                    logger.fine("connection IOException caught: " + e);
                    ConnectionErrorAction action = null;
                    if (connection != null) {
                        action = provider.returnErrorConnection(connection, e, logger);
                    }
                    re = new ServerConnectionException(e.getMessage(), request, e);
                    if (action == ConnectionErrorAction.RETRY) break block14;
                    if (action == null) {
                        logger.warning("Cannot obtain connection: " + e.getMessage());
                    } else {
                        logger.fine("Provider error action=" + action + ", throwing: " + re);
                    }
                    throw re;
                }
            }
            ++t;
        }
        logger.info("automatic query retries (" + retries + ") exhausted, throwing: " + re);
        if (re != null) {
            throw re;
        }
        String msg = "BAD INTERNAL STATE: retries exhausted, no prior retryable exception";
        logger.severe(msg);
        throw new RequestException(msg, request);
    }

    protected void addHandler(int code, ResponseHandler handler) {
        AbstractRequestController.addHandler(this.handlers, code, handler);
    }

    protected static void addHandler(Map<Integer, ResponseHandler> handlers, int code, ResponseHandler handler) {
        handlers.put(new Integer(code), handler);
    }

    protected void addDefaultHandler(ResponseHandler handler) {
        AbstractRequestController.addDefaultHandler(this.handlers, handler);
    }

    protected static void addDefaultHandler(Map<Integer, ResponseHandler> handlers, ResponseHandler handler) {
        handlers.put(DEFAULT_HANDLER_KEY, handler);
    }

    protected ResponseHandler findHandler(int responseCode) {
        ResponseHandler handler = this.handlers.get(new Integer(responseCode));
        if (handler != null) {
            return handler;
        }
        return this.handlers.get(DEFAULT_HANDLER_KEY);
    }

    protected abstract long interTryDelay(long var1, int var3);

    private void sleepFor(long millis) {
        long now;
        if (dontSleep || millis <= 0L) {
            return;
        }
        long wakeupTime = System.currentTimeMillis() + millis;
        while ((now = System.currentTimeMillis()) < wakeupTime) {
            long sleepTime = wakeupTime - now;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void setConnectionTimeout(ServerConnection connection, HttpChannel http) {
        long expiryTime = 0L;
        try {
            expiryTime = http.getResponseKeepaliveExpireTime();
        }
        catch (IOException iOException) {}
        connection.setTimeoutTime(expiryTime);
    }

    protected void addCommonHeaders(HttpChannel http, SessionImpl session, String method, String uri, RequestOptions options) {
        String authorization = session.getAuthString(method, uri);
        if (authorization != null) {
            http.setRequestHeader("Authorization", authorization);
        }
        http.setRequestHeader("User-Agent", session.userAgentString());
        http.setRequestHeader("Accept", "text/html, text/xml, image/gif, image/jpeg, */*");
        if (options.getRequestName() != null) {
            http.setRequestHeader("Referer", options.getRequestName());
        }
    }
}

