/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.xquery.marklogic.io.IOHelper;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmBinary;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractItem;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.StreamableItem;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BinaryImpl
extends AbstractItem
implements XdmBinary,
StreamableItem {
    private InputStream stream;
    private byte[] bytes = null;

    public BinaryImpl(InputStream bodyStream, boolean cache) {
        super(ValueType.BINARY);
        this.stream = bodyStream;
        if (cache) {
            this.asBinaryData();
        }
    }

    public boolean isFetchable() {
        return this.bytes != null || this.stream != null;
    }

    public void invalidate() {
        this.bytes = null;
        if (this.stream != null) {
            try {
                this.stream.skip(Long.MAX_VALUE);
                this.stream.close();
            }
            catch (IOException iOException) {}
            this.stream = null;
        }
    }

    public boolean isCached() {
        return this.bytes != null;
    }

    public Reader asReader() {
        return new InputStreamReader(this.asInputStream());
    }

    public InputStream asInputStream() {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        InputStream tmp = this.stream;
        this.stream = null;
        return tmp;
    }

    public String asString() {
        try {
            return new String(this.asBinaryData(), "UFT-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.asBinaryData());
        }
    }

    public byte[] asBinaryData() {
        if (this.bytes != null) {
            return (byte[])this.bytes.clone();
        }
        if (this.stream == null) {
            throw new IllegalStateException("stream data has already been consumed");
        }
        try {
            this.bytes = IOHelper.byteArrayFromStream(this.stream);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException buffering binary data", e);
        }
        this.stream = null;
        return (byte[])this.bytes.clone();
    }

    public Node asW3cNode(DocumentBuilder docBuilder) throws IOException, SAXException {
        throw new UnsupportedOperationException("binary() cannot be converted to a W3C Node");
    }

    public Node asW3cNode() throws ParserConfigurationException, IOException, SAXException {
        return this.asW3cNode(null);
    }
}

