/*******************************************************************************
 * Copyright (c) 2008, 2009 28msec Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Gabriel Petrovay (28msec) - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages;

import java.io.IOException;

public abstract class AbstractMessage {

    private transient int flags;
    private transient int id;
    private transient int length;

    public AbstractMessage(int id) {
        this.id = id;
    }

    public int getFlags() {
        return flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public abstract byte[] toByteArray() throws IOException;

    public abstract boolean equals(AbstractMessage message);

    public abstract byte[] serializeData();

    public abstract void deserializeData(byte[] data);

    protected boolean isDataEqual(AbstractMessage message) {
        return true;
    }
}
