xquery version "1.0-ml";

(: Copyright (c) 2002-2009 Mark Logic Corporation. All rights reserved.
 : 
 :  This program and the accompanying materials are made available
 :  under the terms of the Eclipse Public License v1.0 which
 :  accompanies this distribution, and is available at
 :  http://www.eclipse.org/legal/epl-v10.html
 : 
 :  Contributors:
 :      Mark Logic, Inc.
 :)

module namespace xdmp="http://marklogic.com/xdmp";

declare function xdmp:access($uri as xs:string, $action as xs:string) as xs:boolean external;
declare function xdmp:add-response-header($name as xs:string, $value as xs:string) as empty-sequence() external;
declare function xdmp:amp($namespace as xs:string, $localname as xs:string, $module-uri as xs:string, $database as xs:unsignedLong) as xs:integer external;
declare function xdmp:amp-roles($namespace-uri as xs:string, $localname as xs:string, $document-uri as xs:string, $database-id as xs:unsignedLong) as xs:unsignedLong* external;
declare function xdmp:apply($function as xdmp:function) as item()* external;
declare function xdmp:apply($function as xdmp:function, $params-1-to-N as item()*) as item()* external;
declare function xdmp:architecture() as xs:string external;
declare function xdmp:base64-decode($encoded as xs:string) as xs:string external;
declare function xdmp:base64-encode($plaintext as xs:string) as xs:string external;
declare function xdmp:can-grant-roles($roles as xs:string*) as empty-sequence() external;
declare function xdmp:castable-as($namespace-uri as xs:string, $local-name as xs:string, $item as item()) as xs:boolean external;
declare function xdmp:collation-canonical-uri($collation-uri as xs:string) as xs:string external;
declare function xdmp:collection-delete($uri as xs:string) as empty-sequence() external;
declare function xdmp:collection-locks($uri as xs:string*) as document-node()* external;
declare function xdmp:collection-locks() as document-node()* external;
declare function xdmp:collection-properties($uri as xs:string*) as document-node()* external;
declare function xdmp:collection-properties() as document-node()* external;
declare function xdmp:database($name as xs:string) as xs:unsignedLong external;
declare function xdmp:database() as xs:unsignedLong external;
declare function xdmp:database-backup($forestIDs as unsignedLong*, $pathname as xs:string) as xs:unsignedLong external;
declare function xdmp:database-backup-cancel($jobid as unsignedLong) as xs:boolean external;
declare function xdmp:database-backup-purge($dir as xs:string, $keep-num-backups as xs:unsignedLong) as empty-sequence() external;
declare function xdmp:database-backup-status($jobid as unsignedLong) as element() external;
declare function xdmp:database-backup-status($jobid as unsignedLong, $hostid as unsignedLong) as element() external;
declare function xdmp:database-backup-validate($forestIDs as unsignedLong*, $pathname as xs:string) as element() external;
declare function xdmp:database-forests($database as xs:unsignedLong) as xs:unsignedLong* external;
declare function xdmp:database-name($id as xs:unsignedLong) as xs:string external;
declare function xdmp:database-restore($forestIDs as unsignedLong*, $pathname as xs:string) as xs:unsignedLong external;
declare function xdmp:database-restore($forestIDs as unsignedLong*, $pathname as xs:string, $restoreToTime as xs:dateTime?) as xs:unsignedLong external;
declare function xdmp:database-restore-cancel($jobid as unsignedLong) as xs:boolean external;
declare function xdmp:database-restore-status($jobid as unsignedLong) as element() external;
declare function xdmp:database-restore-validate($forestIDs as unsignedLong*, $pathname as xs:string) as element() external;
declare function xdmp:database-restore-validate($forestIDs as unsignedLong*, $pathname as xs:string, $restoreToTime as xs:dateTime) as element() external;
declare function xdmp:databases() as xs:unsignedLong* external;
declare function xdmp:default-collections($uri as xs:string) as element()* external;
declare function xdmp:default-collections() as element()* external;
declare function xdmp:default-permissions($uri as xs:string) as element()* external;
declare function xdmp:default-permissions() as element()* external;
declare function xdmp:describe($item as item()*) as xs:string external;
declare function xdmp:describe($item as item()*, $maxSequenceLength as xs:unsignedInt?) as xs:string external;
declare function xdmp:describe($item as item()*, $maxSequenceLength as xs:unsignedInt?, $maxItemLength as xs:unsignedInt*) as xs:string external;
declare function xdmp:diacritic-less($string as xs:string) as xs:string external;
declare function xdmp:directory($uri as xs:string*) as document-node()* external;
declare function xdmp:directory($uri as xs:string*, $depth as xs:string?) as document-node()* external;
declare function xdmp:directory-create($uri as xs:string) as empty-sequence() external;
declare function xdmp:directory-create($uri as xs:string, $permissions as element(sec:permission)*) as empty-sequence() external;
declare function xdmp:directory-create($uri as xs:string, $permissions as element(sec:permission)*, $collections as xs:string*) as empty-sequence() external;
declare function xdmp:directory-create($uri as xs:string, $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?) as empty-sequence() external;
declare function xdmp:directory-create($uri as xs:string, $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?, $forest-ids as xs:unsignedLong*) as empty-sequence() external;
declare function xdmp:directory-delete($uri as xs:string) as empty-sequence() external;
declare function xdmp:directory-locks($uri as xs:string*) as document-node()* external;
declare function xdmp:directory-locks($uri as xs:string*, $depth as xs:string?) as document-node()* external;
declare function xdmp:directory-properties($uri as xs:string) as document-node()* external;
declare function xdmp:directory-properties($uri as xs:string, $depth as xs:string?) as document-node()* external;
declare function xdmp:document-add-collections($uri as xs:string, $collections as xs:string*) as empty-sequence() external;
declare function xdmp:document-add-permissions($uri as xs:string, $permissions as element(sec:permission)*) as empty-sequence() external;
declare function xdmp:document-add-properties($uri as xs:string, $props as element()*) as empty-sequence() external;
declare function xdmp:document-delete($uri as xs:string) as empty-sequence() external;
declare function xdmp:document-forest($uri as xs:string) as xs:integer? external;
declare function xdmp:document-forest($uri as xs:string, $forest-ids as xs:unsignedLong*) as xs:integer? external;
declare function xdmp:document-get($location as xs:string) as node() external;
declare function xdmp:document-get($location as xs:string, $options as node()?) as node() external;
declare function xdmp:document-get-collections($uri as xs:string) as xs:string* external;
declare function xdmp:document-get-permissions($uri as xs:string) as element()* external;
declare function xdmp:document-get-properties($uri as xs:string, $property as xs:QName) as element()* external;
declare function xdmp:document-get-quality($uri as xs:string) as xs:integer? external;
declare function xdmp:document-insert($uri as xs:string, $root as node()) as empty-sequence() external;
declare function xdmp:document-insert($uri as xs:string, $root as node(), $permissions as element(sec:permission)*) as empty-sequence() external;
declare function xdmp:document-insert($uri as xs:string, $root as node(), $permissions as element(sec:permission)*, $collections as xs:string*) as empty-sequence() external;
declare function xdmp:document-insert($uri as xs:string, $root as node(), $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?) as empty-sequence() external;
declare function xdmp:document-insert($uri as xs:string, $root as node(), $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?, $forest-ids as xs:unsignedLong*) as empty-sequence() external;
declare function xdmp:document-load($location as xs:string) as empty-sequence() external;
declare function xdmp:document-load($location as xs:string, $options as node()?) as empty-sequence() external;
declare function xdmp:document-locks($uri as xs:string*) as document-node()* external;
declare function xdmp:document-locks() as document-node()* external;
declare function xdmp:document-properties($uri as xs:string*) as document-node()* external;
declare function xdmp:document-properties() as document-node()* external;
declare function xdmp:document-remove-collections($uri as xs:string, $collections as xs:string*) as empty-sequence() external;
declare function xdmp:document-remove-permissions($uri as xs:string, $permissions as element(sec:permission)*) as empty-sequence() external;
declare function xdmp:document-remove-properties($uri as xs:string, $property-names as xs:QName*) as empty-sequence() external;
declare function xdmp:document-set-collections($uri as xs:string, $collections as xs:string*) as empty-sequence() external;
declare function xdmp:document-set-permissions($uri as xs:string, $permissions as element(sec:permission)*) as empty-sequence() external;
declare function xdmp:document-set-properties($uri as xs:string, $props as element()*) as empty-sequence() external;
declare function xdmp:document-set-property($uri as xs:string, $prop as element()) as empty-sequence() external;
declare function xdmp:document-set-quality($uri as xs:string, $quality as xs:int) as empty-sequence() external;
declare function xdmp:elapsed-time() as xs:dayTimeDuration external;
declare function xdmp:element-content-type($element as element()) as xs:string external;
declare function xdmp:email($message as node()) as empty-sequence() external;
declare function xdmp:estimate($expression as item()*) as xs:integer external;
declare function xdmp:estimate($expression as item()*, $maximum as xs:double?) as xs:integer external;
declare function xdmp:eval($xquery as xs:string) as item()* external;
declare function xdmp:eval($xquery as xs:string, $vars as item()*) as item()* external;
declare function xdmp:eval($xquery as xs:string, $vars as item()*, $options as node()?) as item()* external;
declare function xdmp:eval-in($xquery as xs:string, $ID as xs:unsignedLong) as item()* external;
declare function xdmp:eval-in($xquery as xs:string, $ID as xs:unsignedLong, $vars as item()*) as item()* external;
declare function xdmp:eval-in($xquery as xs:string, $ID as xs:unsignedLong, $vars as item()*, $modules as xs:unsignedLong?) as item()* external;
declare function xdmp:eval-in($xquery as xs:string, $ID as xs:unsignedLong, $vars as item()*, $modules as xs:unsignedLong?, $root as xs:string?) as item()* external;
declare function xdmp:excel-convert($doc as node(), $filename as xs:string) as node()* external;
declare function xdmp:excel-convert($doc as node(), $filename as xs:string, $options as node()?) as node()* external;
declare function xdmp:exists($expression as item()*) as xs:integer external;
declare function xdmp:filesystem-directory($pathname as xs:string) as element(dir:directory) external;
declare function xdmp:filesystem-file($pathname as xs:string) as xs:string external;
declare function xdmp:forest($name as xs:string) as xs:unsignedLong external;
declare function xdmp:forest-backup($forestID as unsignedLong, $pathname as xs:string) as empty-sequence() external;
declare function xdmp:forest-clear($forestIDs as unsignedLong*) as empty-sequence() external;
declare function xdmp:forest-counts($forest-id as xs:unsignedLong) as element(forest-counts) external;
declare function xdmp:forest-counts($forest-id as xs:unsignedLong, $show-elements as xs:string*) as element(forest-counts) external;
declare function xdmp:forest-databases($forest as xs:unsignedLong) as xs:unsignedLong external;
declare function xdmp:forest-name($id as xs:unsignedLong) as xs:string external;
declare function xdmp:forest-restart($forestID as unsignedLong) as empty-sequence() external;
declare function xdmp:forest-restore($forestID as unsignedLong, $pathname as xs:string) as empty-sequence() external;
declare function xdmp:forest-status($forest-id as xs:unsignedLong) as element(forest-status) external;
declare function xdmp:forests() as xs:unsignedLong* external;
declare function xdmp:from-json($arg as xs:string) as item()* external;
declare function xdmp:function($function as xs:QName) as xdmp:function external;
declare function xdmp:function($function as xs:QName, $module-path as xs:string?) as xdmp:function external;
declare function xdmp:function-module($function as xdmp:function) as xs:string external;
declare function xdmp:function-name($function as xdmp:function) as xs:QName external;
declare function xdmp:get($path as xs:string) as node() external;
declare function xdmp:get($path as xs:string, $default-namespace as xs:string?) as node() external;
declare function xdmp:get($path as xs:string, $default-namespace as xs:string?, $options as xs:string*) as node() external;
declare function xdmp:get-current-roles() as xs:unsignedLong* external;
declare function xdmp:get-current-user() as xs:string external;
declare function xdmp:get-request-body($format as xs:string?) as item()* external;
declare function xdmp:get-request-body() as item()* external;
declare function xdmp:get-request-client-address() as xs:string? external;
declare function xdmp:get-request-client-certificate() as xs:string? external;
declare function xdmp:get-request-field($name as xs:string) as xs:string* external;
declare function xdmp:get-request-field($name as xs:string, $default as xs:string?) as xs:string* external;
declare function xdmp:get-request-field-content-type($field-name as xs:string) as xs:string* external;
declare function xdmp:get-request-field-filename($field-name as xs:string) as xs:string* external;
declare function xdmp:get-request-field-names() as xs:string* external;
declare function xdmp:get-request-header($name as xs:string) as xs:string* external;
declare function xdmp:get-request-header($name as xs:string, $default as xs:string?) as xs:string* external;
declare function xdmp:get-request-header-names() as xs:string* external;
declare function xdmp:get-request-method() as xs:string external;
declare function xdmp:get-request-path() as xs:string external;
declare function xdmp:get-request-protocol() as xs:string? external;
declare function xdmp:get-request-url() as xs:string external;
declare function xdmp:get-request-user() as xs:unsignedLong external;
declare function xdmp:get-request-username() as xs:string external;
declare function xdmp:get-response-code() as item()* external;
declare function xdmp:get-response-encoding() as xs:string external;
declare function xdmp:get-session-field($name as xs:string) as item()* external;
declare function xdmp:get-session-field($name as xs:string, $default as item()*) as item()* external;
declare function xdmp:get-session-field-names() as xs:string* external;
declare function xdmp:group($name as xs:string) as xs:unsignedLong external;
declare function xdmp:group() as xs:unsignedLong external;
declare function xdmp:group-hosts($name as xs:unsignedLong) as xs:unsignedLong* external;
declare function xdmp:group-hosts() as xs:unsignedLong* external;
declare function xdmp:group-name($name as xs:unsignedLong) as xs:string external;
declare function xdmp:group-name() as xs:string external;
declare function xdmp:group-servers($name as xs:unsignedLong) as xs:unsignedLong* external;
declare function xdmp:group-servers() as xs:unsignedLong* external;
declare function xdmp:groups() as xs:unsignedLong* external;
declare function xdmp:has-privilege($privileges as xs:string*, $kind as xs:string) as xs:boolean external;
declare function xdmp:hash32($string as xs:string) as xs:unsignedInt external;
declare function xdmp:hash64($string as xs:string) as xs:unsignedLong external;
declare function xdmp:hex-to-integer($hex as xs:string) as xs:integer external;
declare function xdmp:host($name as xs:string) as xs:unsignedLong external;
declare function xdmp:host() as xs:unsignedLong external;
declare function xdmp:host-name($ID as xs:unsignedLong) as xs:string external;
declare function xdmp:host-status($host-id as xs:unsignedLong) as element(host-status) external;
declare function xdmp:hosts() as xs:unsignedLong* external;
declare function xdmp:http-delete($uri as xs:string) as item()+ external;
declare function xdmp:http-delete($uri as xs:string, $options as node()?) as item()+ external;
declare function xdmp:http-get($uri as xs:string) as item()+ external;
declare function xdmp:http-get($uri as xs:string, $options as node()?) as item()+ external;
declare function xdmp:http-head($uri as xs:string) as item()+ external;
declare function xdmp:http-head($uri as xs:string, $options as node()?) as item()+ external;
declare function xdmp:http-options($uri as xs:string) as item()+ external;
declare function xdmp:http-options($uri as xs:string, $options as node()?) as item()+ external;
declare function xdmp:http-post($uri as xs:string) as item()+ external;
declare function xdmp:http-post($uri as xs:string, $options as node()?) as item()+ external;
declare function xdmp:http-put($uri as xs:string) as item()+ external;
declare function xdmp:http-put($uri as xs:string, $options as node()?) as item()+ external;
declare function xdmp:integer-to-hex($val as xs:integer) as xs:string external;
declare function xdmp:integer-to-octal($val as xs:integer) as xs:string external;
declare function xdmp:invoke($path as xs:string) as item()* external;
declare function xdmp:invoke($path as xs:string, $vars as item()*) as item()* external;
declare function xdmp:invoke($path as xs:string, $vars as item()*, $options as node()?) as item()* external;
declare function xdmp:invoke-in($uri as xs:string, $ID as xs:unsignedLong) as item()* external;
declare function xdmp:invoke-in($uri as xs:string, $ID as xs:unsignedLong, $vars as item()*) as item()* external;
declare function xdmp:invoke-in($uri as xs:string, $ID as xs:unsignedLong, $vars as item()*, $modules as xs:unsignedLong?) as item()* external;
declare function xdmp:invoke-in($uri as xs:string, $ID as xs:unsignedLong, $vars as item()*, $modules as xs:unsignedLong?, $root as xs:string?) as item()* external;
declare function xdmp:load($path as xs:string) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?, $permissions as element(sec:permission)*) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?, $permissions as element(sec:permission)*, $collections as xs:string*) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?, $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?, $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?, $default-namespace as xs:string?) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?, $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?, $default-namespace as xs:string?, $options as xs:string*) as empty-sequence() external;
declare function xdmp:load($path as xs:string, $uri as xs:string?, $permissions as element(sec:permission)*, $collections as xs:string*, $quality as xs:int?, $default-namespace as xs:string?, $options as xs:string*, $forest-ids as xs:unsignedLong*) as empty-sequence() external;
declare function xdmp:lock-acquire($uri as xs:string) as empty-sequence() external;
declare function xdmp:lock-acquire($uri as xs:string, $scope as xs:string?) as empty-sequence() external;
declare function xdmp:lock-acquire($uri as xs:string, $scope as xs:string?, $depth as xs:string?) as empty-sequence() external;
declare function xdmp:lock-acquire($uri as xs:string, $scope as xs:string?, $depth as xs:string?, $owner as item()?) as empty-sequence() external;
declare function xdmp:lock-acquire($uri as xs:string, $scope as xs:string?, $depth as xs:string?, $owner as item()?, $timeout as xs:unsignedLong?) as empty-sequence() external;
declare function xdmp:lock-release($uri as xs:string) as empty-sequence() external;
declare function xdmp:log($msg as item()*) as empty-sequence() external;
declare function xdmp:log($msg as item()*, $level as xs:string?) as empty-sequence() external;
declare function xdmp:log-level() as xs:string external;
declare function xdmp:login($name as xs:string) as xs:boolean external;
declare function xdmp:login($name as xs:string, $password as xs:string?) as xs:boolean external;
declare function xdmp:login($name as xs:string, $password as xs:string?, $set-session as xs:boolean?) as xs:boolean external;
declare function xdmp:logout() as empty-sequence() external;
declare function xdmp:md5($encoded as xs:string) as xs:string external;
declare function xdmp:merge($options as node()?) as empty-sequence() external;
declare function xdmp:merge() as empty-sequence() external;
declare function xdmp:merge-cancel($forest-ID as xs:unsignedLong, $merge-ID as xs:unsignedLong) as empty-sequence() external;
declare function xdmp:merging() as xs:unsignedLong* external;
declare function xdmp:modules-database() as xs:unsignedLong external;
declare function xdmp:modules-root() as xs:string external;
declare function xdmp:node-database($node as node()) as xs:unsignedLong? external;
declare function xdmp:node-delete($old as node()) as empty-sequence() external;
declare function xdmp:node-insert-after($sibling as node(), $new as node()) as empty-sequence() external;
declare function xdmp:node-insert-before($sibling as node(), $new as node()) as empty-sequence() external;
declare function xdmp:node-insert-child($parent as node(), $new as node()) as empty-sequence() external;
declare function xdmp:node-kind($node as node()?) as xs:string external;
declare function xdmp:node-replace($old as node(), $new as node()) as empty-sequence() external;
declare function xdmp:node-uri($node as node()) as xs:string? external;
declare function xdmp:octal-to-integer($octal as xs:string) as xs:integer external;
declare function xdmp:path($node as node()) as xs:string external;
declare function xdmp:path($node as node(), $include-document as xs:boolean?) as xs:string external;
declare function xdmp:pdf-convert($doc as node(), $filename as xs:string) as node()* external;
declare function xdmp:pdf-convert($doc as node(), $filename as xs:string, $options as node()?) as node()* external;
declare function xdmp:permission($role as xs:string, $capability as xs:string) as element() external;
declare function xdmp:platform() as xs:string external;
declare function xdmp:powerpoint-convert($doc as node(), $filename as xs:string) as node()* external;
declare function xdmp:powerpoint-convert($doc as node(), $filename as xs:string, $options as node()?) as node()* external;
declare function xdmp:pretty-print($xquery as xs:string) as xs:string external;
declare function xdmp:privilege($action as xs:string, $kind as xs:string) as xs:integer external;
declare function xdmp:privilege-roles($action as xs:string, $kind as xs:string) as xs:unsignedLong* external;
declare function xdmp:product-edition() as xs:string external;
declare function xdmp:query-meters() as element() external;
declare function xdmp:query-trace($enabled as xs:boolean) as empty-sequence() external;
declare function xdmp:quote($arg as item()*) as xs:string external;
declare function xdmp:quote($arg as item()*, $options as node()?) as xs:string external;
declare function xdmp:random($max as xs:unsignedLong) as xs:unsignedLong external;
declare function xdmp:random() as xs:unsignedLong external;
declare function xdmp:redirect-response($name as xs:string) as empty-sequence() external;
declare function xdmp:request() as xs:unsignedLong external;
declare function xdmp:request-cancel($hostID as xs:unsignedLong, $serverID as xs:unsignedLong, $requestID as xs:unsignedLong) as empty-sequence() external;
declare function xdmp:request-status($host-id as xs:unsignedLong, $server-id as xs:unsignedLong, $request-id as xs:unsignedLong) as element(request-status) external;
declare function xdmp:request-timestamp() as xs:unsignedLong? external;
declare function xdmp:restart($hostIDs as unsignedLong*, $reason as xs:string) as empty-sequence() external;
declare function xdmp:rethrow() as empty-sequence() external;
declare function xdmp:role($role as xs:string) as xs:integer external;
declare function xdmp:role-roles($name as xs:string) as xs:unsignedLong* external;
declare function xdmp:save($path as xs:string, $node as node()) as empty-sequence() external;
declare function xdmp:save($path as xs:string, $node as node(), $options as node()?) as empty-sequence() external;
declare function xdmp:schema-database() as xs:unsignedLong external;
declare function xdmp:security-assert($privileges as xs:string*, $kind as xs:string) as empty-sequence() external;
declare function xdmp:security-database() as xs:unsignedLong external;
declare function xdmp:server($name as xs:string) as xs:unsignedLong+ external;
declare function xdmp:server() as xs:unsignedLong+ external;
declare function xdmp:server-name($id as xs:unsignedLong) as xs:string external;
declare function xdmp:server-status($host-id as xs:unsignedLong, $server-id as xs:unsignedLong) as element(server-status) external;
declare function xdmp:servers() as xs:unsignedLong* external;
declare function xdmp:set($variable as item()*, $expr as item()*) as empty-sequence() external;
declare function xdmp:set-request-time-limit($time-limit as xs:unsignedInt) as empty-sequence() external;
declare function xdmp:set-request-time-limit($time-limit as xs:unsignedInt, $hostID as xs:unsignedLong?) as empty-sequence() external;
declare function xdmp:set-request-time-limit($time-limit as xs:unsignedInt, $hostID as xs:unsignedLong?, $serverID as xs:unsignedLong?) as empty-sequence() external;
declare function xdmp:set-request-time-limit($time-limit as xs:unsignedInt, $hostID as xs:unsignedLong?, $serverID as xs:unsignedLong?, $requestID as xs:unsignedLong?) as empty-sequence() external;
declare function xdmp:set-response-code($code as xs:integer, $message as xs:string) as empty-sequence() external;
declare function xdmp:set-response-content-type($name as xs:string) as empty-sequence() external;
declare function xdmp:set-response-encoding($encoding as xs:string) as empty-sequence() external;
declare function xdmp:set-session-field($name as xs:string, $value as item()*) as item()* external;
declare function xdmp:shutdown($hostIDs as unsignedLong*, $reason as xs:string) as empty-sequence() external;
declare function xdmp:sleep($msec as xs:unsignedInt) as empty-sequence() external;
declare function xdmp:spawn($path as xs:string) as empty-sequence() external;
declare function xdmp:spawn($path as xs:string, $vars as item()*) as empty-sequence() external;
declare function xdmp:spawn($path as xs:string, $vars as item()*, $options as node()?) as empty-sequence() external;
declare function xdmp:spawn-in($path as xs:string, $ID as xs:unsignedLong) as empty-sequence() external;
declare function xdmp:spawn-in($path as xs:string, $ID as xs:unsignedLong, $vars as item()*) as empty-sequence() external;
declare function xdmp:spawn-in($path as xs:string, $ID as xs:unsignedLong, $vars as item()*, $modules as xs:unsignedLong?) as empty-sequence() external;
declare function xdmp:spawn-in($path as xs:string, $ID as xs:unsignedLong, $vars as item()*, $modules as xs:unsignedLong?, $root as xs:string?) as empty-sequence() external;
declare function xdmp:strftime($format as xs:string, $value as xs:dateTime) as xs:string external;
declare function xdmp:subbinary($source as binary(), $starting-location as xs:double) as binary() external;
declare function xdmp:subbinary($source as binary(), $starting-location as xs:double, $length as xs:double) as binary() external;
declare function xdmp:tidy($doc as xs:string) as node()+ external;
declare function xdmp:tidy($doc as xs:string, $options as node()?) as node()+ external;
declare function xdmp:to-json($item as item()*) as xs:string external;
declare function xdmp:trace($name as xs:string, $value as item()*) as empty-sequence() external;
declare function xdmp:triggers-database() as xs:unsignedLong external;
declare function xdmp:unpath($expr as xs:string) as item()* external;
declare function xdmp:unquote($arg as xs:string) as document-node()+ external;
declare function xdmp:unquote($arg as xs:string, $default-namespace as xs:string?) as document-node()+ external;
declare function xdmp:unquote($arg as xs:string, $default-namespace as xs:string?, $options as xs:string*) as document-node()+ external;
declare function xdmp:uri-content-type($uri as xs:string) as xs:string external;
declare function xdmp:uri-format($uri as xs:string) as xs:string external;
declare function xdmp:uri-is-file($uri as xs:string) as xs:boolean? external;
declare function xdmp:url-decode($encoded as xs:string) as xs:string external;
declare function xdmp:url-encode($plaintext as xs:string) as xs:string external;
declare function xdmp:url-encode($plaintext as xs:string, $noSpacePlus as xs:boolean?) as xs:string external;
declare function xdmp:user($user as xs:string) as xs:integer external;
declare function xdmp:user-last-login($user as xs:unsignedLong) as element(last-login)? external;
declare function xdmp:user-roles($name as xs:string) as xs:unsignedLong* external;
declare function xdmp:value($expr as xs:string) as item()* external;
declare function xdmp:version() as xs:string external;
declare function xdmp:with-namespaces($nsbindings as xs:string*, $expr as item()*) as item()* external;
declare function xdmp:word-convert($doc as node(), $filename as xs:string) as node()* external;
declare function xdmp:word-convert($doc as node(), $filename as xs:string, $options as node()?) as node()* external;
declare function xdmp:xquery-version() as xs:string external;
declare function xdmp:zip-create($manifest as node(), $nodes as node()+) as binary() external;
declare function xdmp:zip-get($zipfile as binary(), $name as xs:string) as node()+ external;
declare function xdmp:zip-get($zipfile as binary(), $name as xs:string, $options as node()?) as node()+ external;
declare function xdmp:zip-manifest($zipfile as binary()) as node() external; 
