xquery version "1.0-ml";

(: Copyright (c) 2002-2009 Mark Logic Corporation. All rights reserved.
 : 
 :  This program and the accompanying materials are made available
 :  under the terms of the Eclipse Public License v1.0 which
 :  accompanies this distribution, and is available at
 :  http://www.eclipse.org/legal/epl-v10.html
 : 
 :  Contributors:
 :      Mark Logic, Inc.
 :)

module namespace cts="http://marklogic.com/cts";

declare function cts:and-not-query($positive-query as cts:query, $negative-query as cts:query) as cts:and-not-query external;
declare function cts:and-not-query-negative-query($query as cts:and-not-query) as cts:query external;
declare function cts:and-not-query-positive-query($query as cts:and-not-query) as cts:query external;
declare function cts:and-query($queries as cts:query*) as cts:and-query external;
declare function cts:and-query($queries as cts:query*, $options as xs:string*) as cts:and-query external;
declare function cts:and-query-options($query as cts:and-query) as xs:string* external;
declare function cts:and-query-queries($query as cts:and-query) as cts:query* external;
declare function cts:arc-intersection($p1 as cts:point, $p2 as cts:point, $q1 as cts:point, $q2 as cts:point) as cts:point external;
declare function cts:arc-intersection($p1 as cts:point, $p2 as cts:point, $q1 as cts:point, $q2 as cts:point, $options as xs:string*) as cts:point external;
declare function cts:bearing($p1 as cts:point, $p2 as cts:point) as xs:double external;
declare function cts:bearing($p1 as cts:point, $p2 as cts:point, $options as xs:string*) as xs:double external;
declare function cts:box($south as xs:float, $west as xs:float, $north as xs:float, $east as xs:float) as cts:box external;
declare function cts:box-east($box as cts:box) as xs:float external;
declare function cts:box-north($box as cts:box) as xs:float external;
declare function cts:box-south($box as cts:box) as xs:float external;
declare function cts:box-west($box as cts:box) as xs:float external;
declare function cts:circle($radius as xs:float, $center as cts:point) as cts:circle external;
declare function cts:circle-center($circle as cts:circle) as cts:point external;
declare function cts:circle-radius($circle as cts:circle) as xs:float external;
declare function cts:classify($data-nodes as node()*, $classifier as element(cts:classifier), $options as element()?, $training-nodes as node()*) as element(cts:label)* external;
declare function cts:collection-match($pattern as xs:string) as xs:string* external;
declare function cts:collection-match($pattern as xs:string, $options as xs:string*) as xs:string* external;
declare function cts:collection-match($pattern as xs:string, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:collection-match($pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:collection-match($pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:collection-query($uris as xs:string*) as cts:collection-query external;
declare function cts:collection-query-uris($query as cts:collection-query) as xs:string* external;
declare function cts:collections($start as xs:string?) as xs:string* external;
declare function cts:collections($start as xs:string?, $options as xs:string*) as xs:string* external;
declare function cts:collections($start as xs:string?, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:collections($start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:collections($start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:collections() as xs:string* external;
declare function cts:confidence($node as node()) as xs:float external;
declare function cts:confidence() as xs:float external;
declare function cts:contains($nodes as node()*, $query as cts:query) as xs:boolean? external;
declare function cts:deregister($id as xs:unsignedLong) as empty-sequence() external;
declare function cts:destination($p as cts:point, $bearing as xs:double, $distance as xs:double) as cts:point external;
declare function cts:destination($p as cts:point, $bearing as xs:double, $distance as xs:double, $options as xs:string*) as cts:point external;
declare function cts:directory-query($uris as xs:string*) as cts:directory-query external;
declare function cts:directory-query($uris as xs:string*, $depth as xs:string?) as cts:directory-query external;
declare function cts:directory-query-depth($query as cts:directory-query) as xs:string external;
declare function cts:directory-query-uris($query as cts:directory-query) as xs:string* external;
declare function cts:distance($p1 as cts:point, $p2 as cts:point) as xs:double external;
declare function cts:distance($p1 as cts:point, $p2 as cts:point, $options as xs:string*) as xs:double external;
declare function cts:document-query($uris as xs:string*) as cts:document-query external;
declare function cts:document-query-uris($query as cts:document-query) as xs:string* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:range)* external;
declare function cts:element-attribute-pair-geospatial-query($element-name as xs:QName*, $latitude-attribute-names as xs:QName*, $longitude-attribute-names as xs:QName*, $regions as cts:region*) as cts:element-attribute-pair-geospatial-query external;
declare function cts:element-attribute-pair-geospatial-query($element-name as xs:QName*, $latitude-attribute-names as xs:QName*, $longitude-attribute-names as xs:QName*, $regions as cts:region*, $options as xs:string*) as cts:element-attribute-pair-geospatial-query external;
declare function cts:element-attribute-pair-geospatial-query($element-name as xs:QName*, $latitude-attribute-names as xs:QName*, $longitude-attribute-names as xs:QName*, $regions as cts:region*, $options as xs:string*, $weight as xs:double?) as cts:element-attribute-pair-geospatial-query external;
declare function cts:element-attribute-pair-geospatial-query-element-name($query as cts:element-attribute-pair-geospatial-query) as xs:QName* external;
declare function cts:element-attribute-pair-geospatial-query-latitude-name($query as cts:element-attribute-pair-geospatial-query) as xs:QName* external;
declare function cts:element-attribute-pair-geospatial-query-longitude-name($query as cts:element-attribute-pair-geospatial-query) as xs:QName* external;
declare function cts:element-attribute-pair-geospatial-query-options($query as cts:element-attribute-pair-geospatial-query) as xs:string* external;
declare function cts:element-attribute-pair-geospatial-query-region($query as cts:element-attribute-pair-geospatial-query) as cts:region* external;
declare function cts:element-attribute-pair-geospatial-query-weight($query as cts:element-attribute-pair-geospatial-query) as xs:double external;
declare function cts:element-attribute-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType) as xs:anyAtomicType* external;
declare function cts:element-attribute-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-attribute-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-attribute-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-attribute-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-attribute-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*) as cts:point* external;
declare function cts:element-attribute-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?) as cts:point* external;
declare function cts:element-attribute-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*) as cts:point* external;
declare function cts:element-attribute-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?) as cts:point* external;
declare function cts:element-attribute-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as cts:point* external;
declare function cts:element-attribute-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as cts:point* external;
declare function cts:element-attribute-range-query($element-name as xs:QName*, $attribute-name as xs:QName*, $operator as xs:string, $value as xs:anyAtomicType*) as cts:element-attribute-range-query external;
declare function cts:element-attribute-range-query($element-name as xs:QName*, $attribute-name as xs:QName*, $operator as xs:string, $value as xs:anyAtomicType*, $options as xs:string*) as cts:element-attribute-range-query external;
declare function cts:element-attribute-range-query($element-name as xs:QName*, $attribute-name as xs:QName*, $operator as xs:string, $value as xs:anyAtomicType*, $options as xs:string*, $weight as xs:double?) as cts:element-attribute-range-query external;
declare function cts:element-attribute-range-query-attribute-name($query as cts:element-attribute-range-query) as xs:QName* external;
declare function cts:element-attribute-range-query-element-name($query as cts:element-attribute-range-query) as xs:QName* external;
declare function cts:element-attribute-range-query-operator($query as cts:element-attribute-range-query) as xs:anyAtomicType* external;
declare function cts:element-attribute-range-query-options($query as cts:element-attribute-range-query) as xs:string* external;
declare function cts:element-attribute-range-query-value($query as cts:element-attribute-range-query) as xs:anyAtomicType* external;
declare function cts:element-attribute-range-query-weight($query as cts:element-attribute-range-query) as xs:double external;
declare function cts:element-attribute-value-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $element-name-2 as xs:QName, $attribute-name-2 as xs:QName?) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $element-name-2 as xs:QName, $attribute-name-2 as xs:QName?, $options as xs:string*) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $element-name-2 as xs:QName, $attribute-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $element-name-2 as xs:QName, $attribute-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $element-name-2 as xs:QName, $attribute-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-geospatial-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-geospatial-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-geospatial-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-geospatial-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-geospatial-co-occurrences($element-name-1 as xs:QName, $attribute-name-1 as xs:QName?, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:co-occurrence)* external;
declare function cts:element-attribute-value-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:anyAtomicType) as xs:anyAtomicType* external;
declare function cts:element-attribute-value-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-attribute-value-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-attribute-value-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-attribute-value-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-attribute-value-query($element-name as xs:QName*, $attribute-name as xs:QName*, $text as xs:string*) as cts:element-attribute-value-query external;
declare function cts:element-attribute-value-query($element-name as xs:QName*, $attribute-name as xs:QName*, $text as xs:string*, $options as xs:string*) as cts:element-attribute-value-query external;
declare function cts:element-attribute-value-query($element-name as xs:QName*, $attribute-name as xs:QName*, $text as xs:string*, $options as xs:string*, $weight as xs:double?) as cts:element-attribute-value-query external;
declare function cts:element-attribute-value-query-attribute-name($query as cts:element-attribute-value-query) as xs:QName* external;
declare function cts:element-attribute-value-query-element-name($query as cts:element-attribute-value-query) as xs:QName* external;
declare function cts:element-attribute-value-query-options($query as cts:element-attribute-value-query) as xs:string* external;
declare function cts:element-attribute-value-query-text($query as cts:element-attribute-value-query) as xs:string* external;
declare function cts:element-attribute-value-query-weight($query as cts:element-attribute-value-query) as xs:double external;
declare function cts:element-attribute-value-ranges($element-names as xs:QName*, $attribute-names as xs:QName*) as element(cts:range)* external;
declare function cts:element-attribute-value-ranges($element-names as xs:QName*, $attribute-names as xs:QName*, $bounds as xs:anyAtomicType*) as element(cts:range)* external;
declare function cts:element-attribute-value-ranges($element-names as xs:QName*, $attribute-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*) as element(cts:range)* external;
declare function cts:element-attribute-value-ranges($element-names as xs:QName*, $attribute-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*, $query as cts:query?) as element(cts:range)* external;
declare function cts:element-attribute-value-ranges($element-names as xs:QName*, $attribute-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:range)* external;
declare function cts:element-attribute-value-ranges($element-names as xs:QName*, $attribute-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:range)* external;
declare function cts:element-attribute-values($element-names as xs:QName*, $attribute-names as xs:QName*) as xs:anyAtomicType* external;
declare function cts:element-attribute-values($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:anyAtomicType?) as xs:anyAtomicType* external;
declare function cts:element-attribute-values($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-attribute-values($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-attribute-values($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-attribute-values($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-attribute-word-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:string) as xs:string* external;
declare function cts:element-attribute-word-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:string, $options as xs:string*) as xs:string* external;
declare function cts:element-attribute-word-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:string, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:element-attribute-word-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:element-attribute-word-match($element-names as xs:QName*, $attribute-names as xs:QName*, $pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:element-attribute-word-query($element-name as xs:QName*, $attribute-name as xs:QName*, $text as xs:string*) as cts:element-attribute-word-query external;
declare function cts:element-attribute-word-query($element-name as xs:QName*, $attribute-name as xs:QName*, $text as xs:string*, $options as xs:string*) as cts:element-attribute-word-query external;
declare function cts:element-attribute-word-query($element-name as xs:QName*, $attribute-name as xs:QName*, $text as xs:string*, $options as xs:string*, $weight as xs:double?) as cts:element-attribute-word-query external;
declare function cts:element-attribute-word-query-attribute-name($query as cts:element-attribute-word-query) as xs:QName* external;
declare function cts:element-attribute-word-query-element-name($query as cts:element-attribute-word-query) as xs:QName* external;
declare function cts:element-attribute-word-query-options($query as cts:element-attribute-word-query) as xs:string* external;
declare function cts:element-attribute-word-query-text($query as cts:element-attribute-word-query) as xs:string* external;
declare function cts:element-attribute-word-query-weight($query as cts:element-attribute-word-query) as xs:double external;
declare function cts:element-attribute-words($element-names as xs:QName*, $attribute-names as xs:QName*) as xs:string* external;
declare function cts:element-attribute-words($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:string?) as xs:string* external;
declare function cts:element-attribute-words($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:string?, $options as xs:string*) as xs:string* external;
declare function cts:element-attribute-words($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:string?, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:element-attribute-words($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:element-attribute-words($element-names as xs:QName*, $attribute-names as xs:QName*, $start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*) as element(cts:range)* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*, $latitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*) as element(cts:range)* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?) as element(cts:range)* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:range)* external;
declare function cts:element-child-geospatial-boxes($parent-element-names as xs:QName*, $child-element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:range)* external;
declare function cts:element-child-geospatial-query($parent-element-name as xs:QName*, $child-element-names as xs:QName*, $regions as cts:box*) as cts:element-child-geospatial-query external;
declare function cts:element-child-geospatial-query($parent-element-name as xs:QName*, $child-element-names as xs:QName*, $regions as cts:box*, $options as xs:string*) as cts:element-child-geospatial-query external;
declare function cts:element-child-geospatial-query($parent-element-name as xs:QName*, $child-element-names as xs:QName*, $regions as cts:box*, $options as xs:string*, $weight as xs:double?) as cts:element-child-geospatial-query external;
declare function cts:element-child-geospatial-query-child-name($query as cts:element-child-geospatial-query) as xs:QName* external;
declare function cts:element-child-geospatial-query-element-name($query as cts:element-child-geospatial-query) as xs:QName* external;
declare function cts:element-child-geospatial-query-options($query as cts:element-child-geospatial-query) as xs:string* external;
declare function cts:element-child-geospatial-query-region($query as cts:element-child-geospatial-query) as cts:region* external;
declare function cts:element-child-geospatial-query-weight($query as cts:element-child-geospatial-query) as xs:double external;
declare function cts:element-child-geospatial-value-match($element-names as xs:QName*, $child-names as xs:QName*, $pattern as xs:anyAtomicType) as xs:anyAtomicType* external;
declare function cts:element-child-geospatial-value-match($element-names as xs:QName*, $child-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-child-geospatial-value-match($element-names as xs:QName*, $child-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-child-geospatial-value-match($element-names as xs:QName*, $child-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-child-geospatial-value-match($element-names as xs:QName*, $child-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-child-geospatial-values($element-names as xs:QName*, $child-names as xs:QName*) as cts:point* external;
declare function cts:element-child-geospatial-values($element-names as xs:QName*, $child-names as xs:QName*, $start as cts:point?) as cts:point* external;
declare function cts:element-child-geospatial-values($element-names as xs:QName*, $child-names as xs:QName*, $start as cts:point?, $options as xs:string*) as cts:point* external;
declare function cts:element-child-geospatial-values($element-names as xs:QName*, $child-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?) as cts:point* external;
declare function cts:element-child-geospatial-values($element-names as xs:QName*, $child-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as cts:point* external;
declare function cts:element-child-geospatial-values($element-names as xs:QName*, $child-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as cts:point* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*) as element(cts:range)* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*, $latitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*) as element(cts:range)* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?) as element(cts:range)* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:range)* external;
declare function cts:element-geospatial-boxes($element-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:range)* external;
declare function cts:element-geospatial-query($element-name as xs:QName*, $regions as cts:region*) as cts:element-geospatial-query external;
declare function cts:element-geospatial-query($element-name as xs:QName*, $regions as cts:region*, $options as xs:string*) as cts:element-geospatial-query external;
declare function cts:element-geospatial-query($element-name as xs:QName*, $regions as cts:region*, $options as xs:string*, $weight as xs:double?) as cts:element-geospatial-query external;
declare function cts:element-geospatial-query-element-name($query as cts:element-geospatial-query) as xs:QName* external;
declare function cts:element-geospatial-query-options($query as cts:element-geospatial-query) as xs:string* external;
declare function cts:element-geospatial-query-region($query as cts:element-geospatial-query) as cts:box* external;
declare function cts:element-geospatial-query-weight($query as cts:element-geospatial-query) as xs:double external;
declare function cts:element-geospatial-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType) as xs:anyAtomicType* external;
declare function cts:element-geospatial-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-geospatial-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-geospatial-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-geospatial-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-geospatial-values($element-names as xs:QName*) as cts:point* external;
declare function cts:element-geospatial-values($element-names as xs:QName*, $start as cts:point?) as cts:point* external;
declare function cts:element-geospatial-values($element-names as xs:QName*, $start as cts:point?, $options as xs:string*) as cts:point* external;
declare function cts:element-geospatial-values($element-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?) as cts:point* external;
declare function cts:element-geospatial-values($element-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as cts:point* external;
declare function cts:element-geospatial-values($element-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as cts:point* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*) as element(cts:range)* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*) as element(cts:range)* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*) as element(cts:range)* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?) as element(cts:range)* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:range)* external;
declare function cts:element-pair-geospatial-boxes($parent-element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $latitude-bounds as xs:double*, $longitude-bounds as xs:double*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:range)* external;
declare function cts:element-pair-geospatial-query($element-name as xs:QName*, $latitude-element-names as xs:QName*, $longitude-element-names as xs:QName*, $regions as cts:box*) as cts:element-pair-geospatial-query external;
declare function cts:element-pair-geospatial-query($element-name as xs:QName*, $latitude-element-names as xs:QName*, $longitude-element-names as xs:QName*, $regions as cts:box*, $options as xs:string*) as cts:element-pair-geospatial-query external;
declare function cts:element-pair-geospatial-query($element-name as xs:QName*, $latitude-element-names as xs:QName*, $longitude-element-names as xs:QName*, $regions as cts:box*, $options as xs:string*, $weight as xs:double?) as cts:element-pair-geospatial-query external;
declare function cts:element-pair-geospatial-query-element-name($query as cts:element-pair-geospatial-query) as xs:QName* external;
declare function cts:element-pair-geospatial-query-latitude-name($query as cts:element-pair-geospatial-query) as xs:QName* external;
declare function cts:element-pair-geospatial-query-longitude-name($query as cts:element-pair-geospatial-query) as xs:QName* external;
declare function cts:element-pair-geospatial-query-options($query as cts:element-pair-geospatial-query) as xs:string* external;
declare function cts:element-pair-geospatial-query-region($query as cts:element-pair-geospatial-query) as cts:region* external;
declare function cts:element-pair-geospatial-query-weight($query as cts:element-pair-geospatial-query) as xs:double external;
declare function cts:element-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType) as xs:anyAtomicType* external;
declare function cts:element-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-pair-geospatial-value-match($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*) as cts:point* external;
declare function cts:element-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?) as cts:point* external;
declare function cts:element-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*) as cts:point* external;
declare function cts:element-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?) as cts:point* external;
declare function cts:element-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as cts:point* external;
declare function cts:element-pair-geospatial-values($element-names as xs:QName*, $latitude-names as xs:QName*, $longitude-names as xs:QName*, $start as cts:point?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as cts:point* external;
declare function cts:element-query($element-name as xs:QName*, $query as cts:query) as cts:element-query external;
declare function cts:element-query-element-name($query as cts:element-query) as xs:QName* external;
declare function cts:element-query-query($query as cts:element-query) as cts:query external;
declare function cts:element-range-query($element-name as xs:QName*, $operator as xs:string, $value as xs:anyAtomicType*) as cts:element-range-query external;
declare function cts:element-range-query($element-name as xs:QName*, $operator as xs:string, $value as xs:anyAtomicType*, $options as xs:string*) as cts:element-range-query external;
declare function cts:element-range-query($element-name as xs:QName*, $operator as xs:string, $value as xs:anyAtomicType*, $options as xs:string*, $weight as xs:double?) as cts:element-range-query external;
declare function cts:element-range-query-element-name($query as cts:element-range-query) as xs:QName* external;
declare function cts:element-range-query-operator($query as cts:element-range-query) as xs:anyAtomicType* external;
declare function cts:element-range-query-options($query as cts:element-range-query) as xs:string* external;
declare function cts:element-range-query-value($query as cts:element-range-query) as xs:anyAtomicType* external;
declare function cts:element-range-query-weight($query as cts:element-range-query) as xs:double external;
declare function cts:element-value-co-occurrences($element-name-1 as xs:QName, $element-name-2 as xs:QName) as element(cts:co-occurrence)* external;
declare function cts:element-value-co-occurrences($element-name-1 as xs:QName, $element-name-2 as xs:QName, $options as xs:string*) as element(cts:co-occurrence)* external;
declare function cts:element-value-co-occurrences($element-name-1 as xs:QName, $element-name-2 as xs:QName, $options as xs:string*, $query as cts:query?) as element(cts:co-occurrence)* external;
declare function cts:element-value-co-occurrences($element-name-1 as xs:QName, $element-name-2 as xs:QName, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:co-occurrence)* external;
declare function cts:element-value-co-occurrences($element-name-1 as xs:QName, $element-name-2 as xs:QName, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:co-occurrence)* external;
declare function cts:element-value-geospatial-co-occurrences($element-name-1 as xs:QName, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?) as element(cts:co-occurrence)* external;
declare function cts:element-value-geospatial-co-occurrences($element-name-1 as xs:QName, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*) as element(cts:co-occurrence)* external;
declare function cts:element-value-geospatial-co-occurrences($element-name-1 as xs:QName, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?) as element(cts:co-occurrence)* external;
declare function cts:element-value-geospatial-co-occurrences($element-name-1 as xs:QName, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:co-occurrence)* external;
declare function cts:element-value-geospatial-co-occurrences($element-name-1 as xs:QName, $geo-element-name as xs:QName, $child-name-1 as xs:QName?, $child-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:co-occurrence)* external;
declare function cts:element-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType) as xs:anyAtomicType* external;
declare function cts:element-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-value-match($element-names as xs:QName*, $pattern as xs:anyAtomicType, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-value-query($element-name as xs:QName*, $text as xs:string*) as cts:element-value-query external;
declare function cts:element-value-query($element-name as xs:QName*, $text as xs:string*, $options as xs:string*) as cts:element-value-query external;
declare function cts:element-value-query($element-name as xs:QName*, $text as xs:string*, $options as xs:string*, $weight as xs:double?) as cts:element-value-query external;
declare function cts:element-value-query-element-name($query as cts:element-value-query) as xs:QName* external;
declare function cts:element-value-query-options($query as cts:element-value-query) as xs:string* external;
declare function cts:element-value-query-text($query as cts:element-value-query) as xs:string* external;
declare function cts:element-value-query-weight($query as cts:element-value-query) as xs:double external;
declare function cts:element-value-ranges($element-names as xs:QName*) as element(cts:range)* external;
declare function cts:element-value-ranges($element-names as xs:QName*, $bounds as xs:anyAtomicType*) as element(cts:range)* external;
declare function cts:element-value-ranges($element-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*) as element(cts:range)* external;
declare function cts:element-value-ranges($element-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*, $query as cts:query?) as element(cts:range)* external;
declare function cts:element-value-ranges($element-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:range)* external;
declare function cts:element-value-ranges($element-names as xs:QName*, $bounds as xs:anyAtomicType*, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:range)* external;
declare function cts:element-values($element-names as xs:QName*) as xs:anyAtomicType* external;
declare function cts:element-values($element-names as xs:QName*, $start as xs:anyAtomicType?) as xs:anyAtomicType* external;
declare function cts:element-values($element-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*) as xs:anyAtomicType* external;
declare function cts:element-values($element-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*, $query as cts:query?) as xs:anyAtomicType* external;
declare function cts:element-values($element-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:anyAtomicType* external;
declare function cts:element-values($element-names as xs:QName*, $start as xs:anyAtomicType?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:anyAtomicType* external;
declare function cts:element-word-match($element-names as xs:QName*, $pattern as xs:string) as xs:string* external;
declare function cts:element-word-match($element-names as xs:QName*, $pattern as xs:string, $options as xs:string*) as xs:string* external;
declare function cts:element-word-match($element-names as xs:QName*, $pattern as xs:string, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:element-word-match($element-names as xs:QName*, $pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:element-word-match($element-names as xs:QName*, $pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:element-word-query($element-name as xs:QName*, $text as xs:string*) as cts:element-word-query external;
declare function cts:element-word-query($element-name as xs:QName*, $text as xs:string*, $options as xs:string*) as cts:element-word-query external;
declare function cts:element-word-query($element-name as xs:QName*, $text as xs:string*, $options as xs:string*, $weight as xs:double?) as cts:element-word-query external;
declare function cts:element-word-query-element-name($query as cts:element-word-query) as xs:QName* external;
declare function cts:element-word-query-options($query as cts:element-word-query) as xs:string* external;
declare function cts:element-word-query-text($query as cts:element-word-query) as xs:string* external;
declare function cts:element-word-query-weight($query as cts:element-word-query) as xs:double external;
declare function cts:element-words($element-names as xs:QName*) as xs:string* external;
declare function cts:element-words($element-names as xs:QName*, $start as xs:string?) as xs:string* external;
declare function cts:element-words($element-names as xs:QName*, $start as xs:string?, $options as xs:string*) as xs:string* external;
declare function cts:element-words($element-names as xs:QName*, $start as xs:string?, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:element-words($element-names as xs:QName*, $start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:element-words($element-names as xs:QName*, $start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:entity-highlight($node as node(), $expr as item()*) as node() external;
declare function cts:field-word-match($field-names as xs:string*, $pattern as xs:string) as xs:string* external;
declare function cts:field-word-match($field-names as xs:string*, $pattern as xs:string, $options as xs:string*) as xs:string* external;
declare function cts:field-word-match($field-names as xs:string*, $pattern as xs:string, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:field-word-match($field-names as xs:string*, $pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:field-word-match($field-names as xs:string*, $pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:field-word-query($field-name as xs:string*, $text as xs:string*) as cts:field-word-query external;
declare function cts:field-word-query($field-name as xs:string*, $text as xs:string*, $options as xs:string*) as cts:field-word-query external;
declare function cts:field-word-query($field-name as xs:string*, $text as xs:string*, $options as xs:string*, $weight as xs:double?) as cts:field-word-query external;
declare function cts:field-word-query-field-name($query as cts:field-word-query) as xs:string* external;
declare function cts:field-word-query-options($query as cts:field-word-query) as xs:string* external;
declare function cts:field-word-query-text($query as cts:field-word-query) as xs:string* external;
declare function cts:field-word-query-weight($query as cts:field-word-query) as xs:double external;
declare function cts:field-words($field-names as xs:string*) as xs:string* external;
declare function cts:field-words($field-names as xs:string*, $start as xs:string?) as xs:string* external;
declare function cts:field-words($field-names as xs:string*, $start as xs:string?, $options as xs:string*) as xs:string* external;
declare function cts:field-words($field-names as xs:string*, $start as xs:string?, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:field-words($field-names as xs:string*, $start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:field-words($field-names as xs:string*, $start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:fitness($node as node()) as xs:float external;
declare function cts:fitness() as xs:float external;
declare function cts:frequency($value as item()) as xs:integer external;
declare function cts:geospatial-co-occurrences($geo-element-name-1 as xs:QName, $child-1-name-1 as xs:QName?, $child-1-name-2 as xs:QName?, $geo-element-name-2 as xs:QName, $child-2-name-1 as xs:QName?, $child-2-name-2 as xs:QName?) as element(cts:co-occurrence)* external;
declare function cts:geospatial-co-occurrences($geo-element-name-1 as xs:QName, $child-1-name-1 as xs:QName?, $child-1-name-2 as xs:QName?, $geo-element-name-2 as xs:QName, $child-2-name-1 as xs:QName?, $child-2-name-2 as xs:QName?, $options as xs:string*) as element(cts:co-occurrence)* external;
declare function cts:geospatial-co-occurrences($geo-element-name-1 as xs:QName, $child-1-name-1 as xs:QName?, $child-1-name-2 as xs:QName?, $geo-element-name-2 as xs:QName, $child-2-name-1 as xs:QName?, $child-2-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?) as element(cts:co-occurrence)* external;
declare function cts:geospatial-co-occurrences($geo-element-name-1 as xs:QName, $child-1-name-1 as xs:QName?, $child-1-name-2 as xs:QName?, $geo-element-name-2 as xs:QName, $child-2-name-1 as xs:QName?, $child-2-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as element(cts:co-occurrence)* external;
declare function cts:geospatial-co-occurrences($geo-element-name-1 as xs:QName, $child-1-name-1 as xs:QName?, $child-1-name-2 as xs:QName?, $geo-element-name-2 as xs:QName, $child-2-name-1 as xs:QName?, $child-2-name-2 as xs:QName?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as element(cts:co-occurrence)* external;
declare function cts:highlight($node as node(), $query as cts:query, $expr as item()*) as node() external;
declare function cts:near-query($queries as cts:query*) as cts:near-query external;
declare function cts:near-query($queries as cts:query*, $distance as xs:double?) as cts:near-query external;
declare function cts:near-query($queries as cts:query*, $distance as xs:double?, $options as xs:string*) as cts:near-query external;
declare function cts:near-query($queries as cts:query*, $distance as xs:double?, $options as xs:string*, $distance-weight as xs:double?) as cts:near-query external;
declare function cts:near-query-distance($query as cts:near-query) as xs:integer external;
declare function cts:near-query-options($query as cts:near-query) as xs:string* external;
declare function cts:near-query-queries($query as cts:near-query) as cts:query external;
declare function cts:near-query-weight($query as cts:near-query) as xs:double external;
declare function cts:not-query($query as cts:query) as cts:not-query external;
declare function cts:not-query($query as cts:query, $weight as xs:double?) as cts:not-query external;
declare function cts:not-query-query($query as cts:not-query) as cts:query external;
declare function cts:not-query-weight($query as cts:element-query) as xs:double external;
declare function cts:or-query($queries as cts:query*) as cts:or-query external;
declare function cts:or-query-queries($query as cts:or-query) as cts:query* external;
declare function cts:point($latitude as xs:float, $longitude as xs:float) as cts:point external;
declare function cts:point-latitude($point as cts:point) as xs:float external;
declare function cts:point-longitude($point as cts:point) as xs:float external;
declare function cts:polygon($vertices as cts:point*) as cts:polygon external;
declare function cts:polygon-vertices($polygon as cts:polygon) as cts:point* external;
declare function cts:properties-query($query as cts:query) as cts:properties-query external;
declare function cts:properties-query-query($query as cts:properties-query) as cts:query external;
declare function cts:quality($node as node()) as xs:integer external;
declare function cts:quality() as xs:integer external;
declare function cts:query($query as element()) as cts:query external;
declare function cts:query() as cts:query external;
declare function cts:register($query as cts:query) as xs:unsignedLong external;
declare function cts:registered-query($ids as xs:unsignedLong*) as cts:registered-query external;
declare function cts:registered-query($ids as xs:unsignedLong*, $options as xs:string*) as cts:registered-query external;
declare function cts:registered-query($ids as xs:unsignedLong*, $options as xs:string*, $weight as xs:double?) as cts:registered-query external;
declare function cts:registered-query-ids($query as cts:registered-query) as xs:unsignedLong* external;
declare function cts:registered-query-options($query as cts:registered-query) as xs:string* external;
declare function cts:registered-query-weight($query as cts:registered-query) as xs:double external;
declare function cts:remainder($node as node()) as xs:integer external;
declare function cts:remainder() as xs:integer external;
declare function cts:reverse-query($nodes as node()*) as cts:reverse-query external;
declare function cts:reverse-query($nodes as node()*, $weight as xs:double?) as cts:reverse-query external;
declare function cts:reverse-query-nodes($query as cts:reverse-query) as node()* external;
declare function cts:reverse-query-weight($query as cts:reverse-query) as xs:double external;
declare function cts:score($node as node()) as xs:integer external;
declare function cts:score() as xs:integer external;
declare function cts:search($expression as node()*, $query as cts:query?) as node()* external;
declare function cts:search($expression as node()*, $query as cts:query?, $options as xs:string*) as node()* external;
declare function cts:search($expression as node()*, $query as cts:query?, $options as xs:string*, $quality-weight as xs:double?) as node()* external;
declare function cts:search($expression as node()*, $query as cts:query?, $options as xs:string*, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as node()* external;
declare function cts:shortest-distance($p1 as cts:point, $v as cts:point+) as xs:double external;
declare function cts:shortest-distance($p1 as cts:point, $v as cts:point+, $options as xs:string*) as xs:double external;
declare function cts:similar-query($nodes as node()*) as cts:similar-query external;
declare function cts:similar-query($nodes as node()*, $weight as xs:double?) as cts:similar-query external;
declare function cts:similar-query-nodes($query as cts:similar-query) as node()* external;
declare function cts:similar-query-weight($query as cts:similar-query) as xs:double external;
declare function cts:stem($text as xs:string) as xs:string* external;
declare function cts:stem($text as xs:string, $language as xs:string?) as xs:string* external;
declare function cts:thresholds($computed-labels as element(cts:label)*, $known-labels as element(cts:label)*) as element(cts:thresholds)? external;
declare function cts:thresholds($computed-labels as element(cts:label)*, $known-labels as element(cts:label)*, $recall-weight as xs:double?) as element(cts:thresholds)? external;
declare function cts:tokenize($text as xs:string) as cts:token* external;
declare function cts:tokenize($text as xs:string, $language as xs:string?) as cts:token* external;
declare function cts:train($training-nodes as node()*, $labels as element(cts:label)*) as element(cts:classifier)? external;
declare function cts:train($training-nodes as node()*, $labels as element(cts:label)*, $options as element()?) as element(cts:classifier)? external;
declare function cts:uri-match($pattern as xs:string) as xs:string* external;
declare function cts:uri-match($pattern as xs:string, $options as xs:string*) as xs:string* external;
declare function cts:uri-match($pattern as xs:string, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:uri-match($pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:uri-match($pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:uris($start as xs:string?) as xs:string* external;
declare function cts:uris($start as xs:string?, $options as xs:string*) as xs:string* external;
declare function cts:uris($start as xs:string?, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:uris($start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:uris($start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:uris() as xs:string* external;
declare function cts:walk($node as node(), $query as cts:query, $expr as item()*) as item()* external;
declare function cts:word-match($pattern as xs:string) as xs:string* external;
declare function cts:word-match($pattern as xs:string, $options as xs:string*) as xs:string* external;
declare function cts:word-match($pattern as xs:string, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:word-match($pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:word-match($pattern as xs:string, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:word-query($text as xs:string*) as cts:word-query external;
declare function cts:word-query($text as xs:string*, $options as xs:string*) as cts:word-query external;
declare function cts:word-query($text as xs:string*, $options as xs:string*, $weight as xs:double?) as cts:word-query external;
declare function cts:word-query-options($query as cts:word-query) as xs:string* external;
declare function cts:word-query-text($query as cts:word-query) as xs:string* external;
declare function cts:word-query-weight($query as cts:word-query) as xs:double external;
declare function cts:words($start as xs:string?) as xs:string* external;
declare function cts:words($start as xs:string?, $options as xs:string*) as xs:string* external;
declare function cts:words($start as xs:string?, $options as xs:string*, $query as cts:query?) as xs:string* external;
declare function cts:words($start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?) as xs:string* external;
declare function cts:words($start as xs:string?, $options as xs:string*, $query as cts:query?, $quality-weight as xs:double?, $forest-ids as xs:unsignedLong*) as xs:string* external;
declare function cts:words() as xs:string* external;
