/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.DelegatingJsonElementVisitor;
import com.google.gson.Escaper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;

class JsonEscapingVisitor
extends DelegatingJsonElementVisitor {
    private final Escaper escaper;

    protected JsonEscapingVisitor(JsonElementVisitor delegate, boolean escapeHtmlChars) {
        this(delegate, new Escaper(escapeHtmlChars));
    }

    protected JsonEscapingVisitor(JsonElementVisitor delegate, Escaper escaper) {
        super(delegate);
        this.escaper = escaper;
    }

    public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) throws IOException {
        super.visitArrayMember(parent, this.escapeJsonPrimitive(member), isFirst);
    }

    public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) throws IOException {
        super.visitObjectMember(parent, memberName, this.escapeJsonPrimitive(member), isFirst);
    }

    public void visitPrimitive(JsonPrimitive primitive) throws IOException {
        super.visitPrimitive(this.escapeJsonPrimitive(primitive));
    }

    private JsonPrimitive escapeJsonPrimitive(JsonPrimitive member) {
        if (member.isString()) {
            String memberValue = member.getAsString();
            member.setValue(this.escaper.escapeJsonString(memberValue));
        }
        return member;
    }
}

