/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.wst.xquery.debug.debugger.zorba.ZorbaDebuggerPlugin;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.MessageHeader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.MessageReader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.ProtocolException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.ReplyMessageHeader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.RequestMessageHeader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractCommandMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ClearMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.EvaluatedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.FramesMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ICommandSets;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.InvalidCommandException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ResumeMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ResumedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.RunMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.SetMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.StartedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.StepMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.SuspendMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.SuspendedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.TerminateMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.TerminatedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.VariablesMessage;

public class MessageFactory
implements ICommandSets {
    public static AbstractCommandMessage buildCommand(int command) {
        return MessageFactory.buildCommand(command, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractCommandMessage buildCommand(int command, byte[] data) {
        int commandSet = command >> 8 & 0xFF;
        if (data == null) {
            data = "{}".getBytes();
        }
        Gson g = new Gson();
        if (ZorbaDebuggerPlugin.DEBUG_ZORBA_DEBUG_PROTOCOL) {
            System.out.println("Building message with data: " + new String(data));
        }
        try {
            switch (commandSet) {
                case 241: {
                    switch (command) {
                        case 61697: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), RunMessage.class);
                        }
                        case 61698: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), SuspendMessage.class);
                        }
                        case 61699: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), ResumeMessage.class);
                        }
                        case 61700: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), TerminateMessage.class);
                        }
                        case 61701: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), StepMessage.class);
                        }
                    }
                }
                case 248: {
                    switch (command) {
                        case 63489: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), StartedMessage.class);
                        }
                        case 63491: {
                            try {
                                g.fromJson(new String(data), SuspendedMessage.class);
                                return (AbstractCommandMessage)g.fromJson(new String(data), SuspendedMessage.class);
                            }
                            catch (JsonParseException e) {
                                e.printStackTrace();
                                data = new String(data).replaceAll("\\\\", "\\\\\\\\").getBytes();
                            }
                            return (AbstractCommandMessage)g.fromJson(new String(data), SuspendedMessage.class);
                        }
                        case 63492: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), ResumedMessage.class);
                        }
                        case 63490: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), TerminatedMessage.class);
                        }
                        case 63493: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), EvaluatedMessage.class);
                        }
                    }
                }
                case 242: {
                    switch (command) {
                        case 61953: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), SetMessage.class);
                        }
                        case 61954: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), ClearMessage.class);
                        }
                    }
                }
                case 244: {
                    switch (command) {
                        case 62466: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), VariablesMessage.class);
                        }
                        case 62467: {
                            return null;
                        }
                        case 62468: {
                            return null;
                        }
                        case 62469: {
                            return null;
                        }
                        case 62470: {
                            return null;
                        }
                        case 62471: {
                            return null;
                        }
                        case 62473: {
                            return (AbstractCommandMessage)g.fromJson(new String(data), FramesMessage.class);
                        }
                    }
                    throw new InvalidCommandException(command);
                }
            }
            throw new InvalidCommandException(command);
        }
        catch (JsonParseException jpe) {
            throw new ProtocolException(jpe.getMessage(), jpe);
        }
    }

    public static AbstractMessage buildReply(int errorCode, byte[] data) {
        return new ReplyMessage(555, errorCode, data);
    }

    public static AbstractMessage buildReply(int errorCode, String message) {
        return new ReplyMessage(555, errorCode, message);
    }

    public static AbstractMessage buildMessage(MessageHeader header, byte[] data) throws InvalidCommandException {
        if (header instanceof ReplyMessageHeader) {
            AbstractReplyMessage message = null;
            ReplyMessageHeader replyHeader = (ReplyMessageHeader)header;
            message = (AbstractReplyMessage)MessageFactory.buildReply(replyHeader.getErrorCode(), data);
            message.setId(replyHeader.getId());
            message.setLength(replyHeader.getMessageLength());
            message.setFlags(replyHeader.getFlags());
            message.setErrorCode(replyHeader.getErrorCode());
            return message;
        }
        if (header instanceof RequestMessageHeader) {
            AbstractCommandMessage message = null;
            RequestMessageHeader requestHeader = (RequestMessageHeader)header;
            message = MessageFactory.buildCommand(requestHeader.getCommandSet() << 8 | requestHeader.getCommand(), data);
            message.setId(requestHeader.getId());
            message.setLength(requestHeader.getMessageLength());
            message.setFlags(requestHeader.getFlags());
            message.setCommandSet(requestHeader.getCommandSet());
            message.setCommand(requestHeader.getCommand());
            return message;
        }
        return null;
    }

    public static AbstractMessage buildMessage(byte[] serialized) {
        MessageReader reader = new MessageReader(new ByteArrayInputStream(serialized));
        try {
            return reader.readMessage();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static AbstractMessage buildHandshake() {
        return new AbstractReplyMessage(0, 0){

            public byte[] toByteArray() throws IOException {
                return "XQHandshake".getBytes();
            }

            public int getId() {
                return 1852076904;
            }

            public int getLength() {
                return 1481721953;
            }
        };
    }
}

