/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.http.MultipartSplitter;

public class SimpleBoundaryPartSplitter
implements MultipartSplitter {
    private static final int MIN_BUFFER_SIZE = 2048;
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private final BoundaryBuffer bbuf;
    private final InputStream httpStream;
    private final Logger logger;

    public SimpleBoundaryPartSplitter(InputStream inputStream, byte[] boundary, int bufSize, Logger loggerArg) {
        this.logger = loggerArg == null ? Logger.getLogger(this.getClass().getName()) : loggerArg;
        this.httpStream = inputStream;
        this.bbuf = new BoundaryBuffer(inputStream, boundary, this.bufferSize(bufSize), this.logger);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Constructed: bufsize=" + this.bbuf.capacity() + ", boundary='" + new String(boundary) + "'");
        }
    }

    private int bufferSize(int bufSize) {
        if (bufSize == 0) {
            return 16384;
        }
        if (bufSize < 2048) {
            return 2048;
        }
        if (bufSize > 0xA00000) {
            return 0xA00000;
        }
        return bufSize;
    }

    public SimpleBoundaryPartSplitter(InputStream inputStream, byte[] boundary, int bufSize) {
        this(inputStream, boundary, bufSize, null);
    }

    public synchronized boolean hasNext() throws IOException {
        return this.bbuf.hasNext();
    }

    public synchronized void next() throws IOException {
        this.bbuf.next();
    }

    public synchronized int read(byte[] bytes, int offset, int length) throws IOException {
        return this.bbuf.read(bytes, offset, length);
    }

    public void close() throws IOException {
        long skipped = this.httpStream.skip(Long.MAX_VALUE);
        if (skipped > 0L && this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("flushed " + skipped + " bytes on close");
        }
    }

    static class BoundaryBuffer {
        private static final byte[] BOUNDARY_LEADIN = "\n--".getBytes();
        private static final byte[] BOUNDARY_LEADOUT = "--\n".getBytes();
        private InputStream is;
        private final ByteBuffer byteBuffer;
        private final byte[] buffer;
        private final byte[] boundary;
        private final Logger logger;
        private int boundaryPosition = -1;
        private int scanPoint = 0;

        public BoundaryBuffer(InputStream is, byte[] boundary, int bufSize, Logger logger) {
            this.is = is;
            this.logger = logger;
            this.boundary = new byte[boundary.length + BOUNDARY_LEADIN.length];
            System.arraycopy(BOUNDARY_LEADIN, 0, this.boundary, 0, BOUNDARY_LEADIN.length);
            System.arraycopy(boundary, 0, this.boundary, BOUNDARY_LEADIN.length, boundary.length);
            this.byteBuffer = ByteBuffer.allocate(Math.max(bufSize, this.boundary.length + BOUNDARY_LEADOUT.length));
            this.buffer = this.byteBuffer.array();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("constructed: bufsize=" + this.byteBuffer.capacity() + ", boundary=" + new String(boundary));
            }
        }

        public int capacity() {
            return this.byteBuffer.capacity();
        }

        public boolean hasNext() throws IOException {
            this.flushToBoundary();
            return !this.atTerminalBoundary();
        }

        public int read(byte[] bytes, int offset, int length) throws IOException {
            boolean logFine = this.logger.isLoggable(Level.FINEST);
            if (logFine) {
                this.logger.finest("enter");
            }
            int toRead = length;
            int bytesRead = 0;
            while (toRead > 0) {
                this.fillBuffer();
                this.scanForBoundary(this.byteBuffer.position());
                int fetchCount = Math.min(toRead, this.readableBytes());
                if (fetchCount == 0) {
                    if (!this.atBoundary()) {
                        throw new IOException("Premature end-of-stream reading result item");
                    }
                    if (!logFine) break;
                    this.logger.finest("end of part, breaking");
                    break;
                }
                if (bytes != null) {
                    if (logFine) {
                        this.logger.finest("copying out " + fetchCount + " bytes, offset=" + (offset + bytesRead));
                    }
                    System.arraycopy(this.buffer, 0, bytes, offset + bytesRead, fetchCount);
                }
                this.compactBuffer(fetchCount);
                bytesRead += fetchCount;
                toRead -= fetchCount;
            }
            if (bytesRead == 0) {
                bytesRead = -1;
            }
            if (logFine) {
                this.logger.finest("leave: bytesRead=" + bytesRead);
            }
            return bytesRead;
        }

        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes == null ? Integer.MAX_VALUE : bytes.length);
        }

        public boolean next() throws IOException {
            this.logger.finest("enter");
            if (!this.atBoundary()) {
                this.flushToBoundary();
            }
            if (this.atTerminalBoundary()) {
                this.logger.finest("terminal, false");
                return false;
            }
            this.compactBuffer(this.boundary.length + 1);
            this.logger.finest("true");
            return true;
        }

        private boolean atBoundary() {
            return this.boundaryPosition == this.scanPoint;
        }

        private boolean atTerminalBoundary() {
            return this.atBoundary() && this.boundaryIsHere(BOUNDARY_LEADOUT, this.boundary.length, this.byteBuffer.position());
        }

        private int readableBytes() {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("scanPoint=" + this.scanPoint);
            }
            return this.scanPoint;
        }

        private void flushToBoundary() throws IOException {
            int rc;
            boolean logFine = this.logger.isLoggable(Level.FINEST);
            if (logFine) {
                this.logger.finest("flushing");
            }
            while ((rc = this.read(null)) != -1) {
                if (!logFine) continue;
                this.logger.finest("  flushed " + rc + " bytes");
            }
            if (logFine) {
                this.logger.finest("done");
            }
        }

        private void compactBuffer(int byteCount) {
            boolean logFine = this.logger.isLoggable(Level.FINEST);
            if (logFine) {
                this.logger.finest("byteCount=" + byteCount + ", buffer=" + this.byteBuffer);
            }
            this.byteBuffer.flip();
            this.byteBuffer.position(byteCount);
            this.byteBuffer.compact();
            this.scanPoint = Math.max(0, this.scanPoint - byteCount);
            this.boundaryPosition = Math.max(-1, this.boundaryPosition - byteCount);
            if (logFine) {
                this.logger.finest("compacted by " + byteCount + ", scanPoint=" + this.scanPoint + ", boundaryPosition=" + this.boundaryPosition);
            }
        }

        private void fillBuffer() throws IOException {
            boolean logFine = this.logger.isLoggable(Level.FINEST);
            if (logFine) {
                this.logger.finest("enter: is null?=" + (this.is == null) + ", count=" + this.byteBuffer.position() + ", remaining=" + this.byteBuffer.remaining() + ", hasRemaining=" + this.byteBuffer.hasRemaining() + ", capacity=" + this.byteBuffer.capacity() + ", scanPoint=" + this.scanPoint + ", boundaryPosition=" + this.boundaryPosition);
            }
            while (this.is != null && this.byteBuffer.hasRemaining()) {
                int position = this.byteBuffer.position();
                int rc = this.is.read(this.buffer, position, this.byteBuffer.remaining());
                if (logFine) {
                    this.logger.finest("read: rc=" + rc);
                }
                if (rc == -1) {
                    if (logFine) {
                        this.logger.finest("EOS, nulling stream");
                    }
                    this.is = null;
                    break;
                }
                this.byteBuffer.position(position + rc);
                if (!logFine) continue;
                this.logger.finest(" added " + rc + " bytes to buffer: pos=" + this.byteBuffer.position() + ", remaining=" + this.byteBuffer.remaining() + ", scanPoint=" + this.scanPoint + ", boundaryPosition=" + this.boundaryPosition);
            }
            if (logFine) {
                this.logger.finest("leave: count=" + this.byteBuffer.position());
            }
        }

        private void scanForBoundary(int limit) {
            boolean logFine = this.logger.isLoggable(Level.FINEST);
            if (this.boundaryPosition != -1) {
                if (logFine) {
                    this.logger.finest("boundaryPosition already set: " + this.boundaryPosition);
                }
                return;
            }
            if (logFine) {
                this.logger.finest("scanning, beginning at " + this.scanPoint + ", limit=" + limit);
            }
            byte first = this.boundary[0];
            while (this.scanPoint < limit) {
                if (this.buffer[this.scanPoint] == first) {
                    if (this.scanPoint + this.boundary.length > limit) {
                        if (!logFine) break;
                        this.logger.finest("breaking, less than boundary size left");
                        break;
                    }
                    if (this.boundaryIsHere(this.boundary, this.scanPoint, limit)) {
                        if (logFine) {
                            this.logger.finest("boundary found, breaking");
                        }
                        this.boundaryPosition = this.scanPoint;
                        break;
                    }
                }
                ++this.scanPoint;
            }
            if (logFine) {
                this.logger.finest("done, scanPoint=" + this.scanPoint + ", boundaryPosition=" + this.boundaryPosition);
            }
        }

        boolean boundaryIsHere(byte[] boundary, int position, int limit) {
            boolean logFine = this.logger.isLoggable(Level.FINEST);
            if (logFine) {
                this.logger.finest("enter: position=" + position + ", limit=" + limit);
            }
            int i = 0;
            while (i < boundary.length) {
                if (boundary[i] != this.buffer[position + i]) {
                    if (logFine) {
                        this.logger.finest("leave: false (2)");
                    }
                    return false;
                }
                ++i;
            }
            if (logFine) {
                this.logger.finest("leave: true");
            }
            return true;
        }
    }
}

