/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class IOHelper {
    private IOHelper() {
    }

    public static BufferedReader newReader(String value) {
        return new BufferedReader(new StringReader(value));
    }

    public static InputStream newStream(String value) {
        return new ByteArrayInputStream(IOHelper.getUtf8Bytes(value));
    }

    public static String literalStringFromReader(Reader reader) throws IOException {
        int rc;
        int SBUF_INIT_SIZE = 32;
        StringBuffer sb = new StringBuffer(SBUF_INIT_SIZE);
        char[] buf = new char[10240];
        while ((rc = reader.read(buf)) > 0) {
            sb.append(buf, 0, rc);
        }
        buf = null;
        if (sb.length() <= SBUF_INIT_SIZE) {
            return sb.toString();
        }
        return sb.substring(0);
    }

    public static String literalStringFromStream(InputStream is) throws IOException {
        return IOHelper.literalStringFromReader(new BufferedReader(IOHelper.newUtf8StreamReader(is)));
    }

    public static String stringFromReader(BufferedReader br) throws IOException {
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        return sb.substring(0);
    }

    public static String stringFromStream(InputStream is) throws IOException {
        return IOHelper.stringFromReader(new BufferedReader(IOHelper.newUtf8StreamReader(is)));
    }

    public static InputStream newUtf8Stream(String s) {
        try {
            return new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(s.getBytes());
        }
    }

    public static Reader newUtf8StreamReader(InputStream is) {
        try {
            return new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(is);
        }
    }

    public static BufferedReader newBufferedUtf8Reader(InputStream stream) {
        return new BufferedReader(IOHelper.newUtf8StreamReader(stream));
    }

    public static byte[] byteArrayFromStream(InputStream inputStream) throws IOException {
        int rc;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        while ((rc = inputStream.read(buffer)) > 0) {
            bos.write(buffer, 0, rc);
        }
        return bos.toByteArray();
    }

    public static String genericExceptionMessage(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            message = e.getClass().getName();
        }
        return message;
    }

    public static String urlDecodeString(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLDecoder.decode(value);
        }
    }

    public static void urlEncodeToStringBuffer(StringBuffer sb, String value) {
        try {
            IOHelper.urlEncodeStringToStringBuffer(value, sb, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sb.append(URLEncoder.encode(value));
        }
    }

    public static String urlEncodeString(String s, String encoding) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        IOHelper.urlEncodeStringToStringBuffer(s, sb, encoding);
        return sb.substring(0);
    }

    public static void urlEncodeStringToStringBuffer(String s, StringBuffer sb, String encoding) throws UnsupportedEncodingException {
        if (IOHelper.containsNonAscii(s)) {
            sb.append(URLEncoder.encode(s, encoding));
            return;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == ' ') {
                sb.append("+");
            } else if (IOHelper.needsEncoding(c)) {
                IOHelper.hexEncodeCharToStringBuffer(sb, c);
            } else {
                sb.append(c);
            }
            ++i;
        }
    }

    private static boolean needsEncoding(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        return c != '*' && c != '_' && c != '.' && c != '-';
    }

    private static boolean containsNonAscii(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (s.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void hexEncodeCharToStringBuffer(StringBuffer sb, char c) {
        sb.append("%");
        String hex = Integer.toHexString(c).toUpperCase();
        if (hex.length() == 1) {
            sb.append("0");
        }
        sb.append(hex);
    }

    private static byte[] getUtf8Bytes(String is) {
        try {
            return is.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return is.getBytes();
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
            ++i;
        }
        return buf.toString();
    }
}

