/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SslByteChannel
implements ByteChannel {
    private final ByteChannel wrappedChannel;
    private final SSLEngine engine;
    protected final Logger logger;
    private ByteBuffer inAppData;
    private final ByteBuffer outAppData;
    private ByteBuffer inNetData;
    private final ByteBuffer outNetData;
    private boolean closed = false;
    private int timeoutMillis = 0;
    private Selector selector = null;

    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    public SslByteChannel(ByteChannel wrappedChannel, SSLEngine engine, Logger logger) {
        this.wrappedChannel = wrappedChannel;
        this.engine = engine;
        this.logger = logger;
        SSLSession session = engine.getSession();
        this.inAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.outAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.inNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.outNetData = ByteBuffer.allocate(session.getPacketBufferSize());
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                try {
                    this.engine.closeOutbound();
                    this.handleHandshake(this.wrapAppData());
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (IOException iOException) {}
                this.wrappedChannel.close();
            }
            finally {
                this.closed = true;
            }
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public int read(ByteBuffer clientBuffer) throws IOException {
        int bytesCopied = this.copyOutClientData(clientBuffer);
        if (bytesCopied > 0) {
            return bytesCopied;
        }
        this.fillBufferFromEngine();
        bytesCopied = this.copyOutClientData(clientBuffer);
        if (bytesCopied > 0) {
            return bytesCopied;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private void fillBufferFromEngine() throws IOException {
        block9: while (true) {
            if ((ser = this.unwrapNetData()).bytesProduced() > 0) {
                return;
            }
            switch (SslByteChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$Status()[ser.getStatus().ordinal()]) {
                case 3: {
                    break;
                }
                case 4: {
                    this.close();
                    return;
                }
                case 2: {
                    appSize = this.engine.getSession().getApplicationBufferSize();
                    b = ByteBuffer.allocate(appSize + this.inAppData.position());
                    this.inAppData.flip();
                    b.put(this.inAppData);
                    this.inAppData = b;
                    continue block9;
                }
                case 1: {
                    netSize = this.engine.getSession().getPacketBufferSize();
                    if (netSize > this.inNetData.capacity()) {
                        b = ByteBuffer.allocate(netSize);
                        this.inNetData.flip();
                        b.put(this.inNetData);
                        this.inNetData = b;
                    }
                    if ((rc = this.timedRead(this.inNetData, this.timeoutMillis)) == 0 && this.timeoutMillis > 0) {
                        throw new IOException("Timeout waiting for read (" + this.timeoutMillis + " milliseconds)");
                    }
                    if (rc != -1) ** break;
                }
            }
            switch (SslByteChannel.$SWITCH_TABLE$javax$net$ssl$SSLEngineResult$HandshakeStatus()[ser.getHandshakeStatus().ordinal()]) {
                case 1: {
                    return;
                }
            }
            this.handleHandshake(ser);
        }
    }

    private int timedRead(ByteBuffer buf, int timeoutMillis) throws IOException {
        SelectableChannel ch;
        if (timeoutMillis <= 0) {
            return this.wrappedChannel.read(buf);
        }
        SelectableChannel selectableChannel = ch = (SelectableChannel)((Object)this.wrappedChannel);
        synchronized (selectableChannel) {
            int n;
            block9: {
                SelectionKey key = null;
                if (this.selector == null) {
                    this.selector = Selector.open();
                }
                try {
                    this.selector.selectNow();
                    ch.configureBlocking(false);
                    key = ch.register(this.selector, 1);
                    this.selector.select(timeoutMillis);
                    n = this.wrappedChannel.read(buf);
                    if (key == null) break block9;
                    key.cancel();
                }
                catch (Throwable throwable) {
                    if (key != null) {
                        key.cancel();
                    }
                    ch.configureBlocking(true);
                    throw throwable;
                }
            }
            ch.configureBlocking(true);
            return n;
        }
    }

    public int write(ByteBuffer clientBuffer) throws IOException {
        int bytesWritten = 0;
        while (clientBuffer.remaining() > 0) {
            bytesWritten += this.pushToEngine(clientBuffer);
        }
        return bytesWritten;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int pushToEngine(ByteBuffer clientBuffer) throws IOException {
        int bytesWritten = 0;
        block9: while (clientBuffer.remaining() > 0) {
            bytesWritten += this.copyInClientData(clientBuffer);
            SSLEngineResult ser = this.wrapAppData();
            switch (ser.getStatus()) {
                case OK: {
                    break;
                }
                case CLOSED: {
                    this.pushNetData();
                    this.close();
                    return bytesWritten;
                }
                case BUFFER_OVERFLOW: {
                    continue block9;
                }
                case BUFFER_UNDERFLOW: {
                    return bytesWritten;
                }
            }
            switch (ser.getHandshakeStatus()) {
                case NOT_HANDSHAKING: {
                    break;
                }
                default: {
                    this.handleHandshake(ser);
                }
            }
        }
        return bytesWritten;
    }

    private void handleHandshake(SSLEngineResult initialSer) throws IOException {
        SSLEngineResult ser = initialSer;
        while (ser.getStatus() != SSLEngineResult.Status.CLOSED) {
            switch (ser.getHandshakeStatus()) {
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    this.pushNetData();
                    ser = this.wrapAppData();
                    break;
                }
                case NEED_WRAP: {
                    this.pushNetData();
                    ser = this.wrapAppData();
                    break;
                }
                case NEED_UNWRAP: {
                    this.pushNetData();
                    if (this.inNetData.position() == 0) {
                        this.wrappedChannel.read(this.inNetData);
                    }
                    ser = this.unwrapNetData();
                    break;
                }
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    return;
                }
            }
        }
    }

    private SSLEngineResult unwrapNetData() throws SSLException {
        this.inNetData.flip();
        SSLEngineResult ser = this.engine.unwrap(this.inNetData, this.inAppData);
        this.inNetData.compact();
        return ser;
    }

    private SSLEngineResult wrapAppData() throws IOException {
        this.outAppData.flip();
        SSLEngineResult ser = this.engine.wrap(this.outAppData, this.outNetData);
        this.outAppData.compact();
        this.pushNetData();
        return ser;
    }

    private void pushNetData() throws IOException {
        this.outNetData.flip();
        while (this.outNetData.remaining() > 0) {
            this.wrappedChannel.write(this.outNetData);
        }
        this.outNetData.compact();
    }

    /*
     * Unable to fully structure code
     */
    private int copyInClientData(ByteBuffer clientBuffer) {
        block2: {
            if (clientBuffer.remaining() == 0) {
                return 0;
            }
            posBefore = clientBuffer.position();
            if (clientBuffer.remaining() >= this.outAppData.remaining()) ** GOTO lbl10
            this.outAppData.put(clientBuffer);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.outAppData.put(clientBuffer.get());
lbl10:
                // 2 sources

                ** while (clientBuffer.hasRemaining() && this.outAppData.hasRemaining())
            }
        }
        return clientBuffer.position() - posBefore;
    }

    /*
     * Unable to fully structure code
     */
    private int copyOutClientData(ByteBuffer clientBuffer) {
        block1: {
            this.inAppData.flip();
            posBefore = this.inAppData.position();
            if (this.inAppData.remaining() > clientBuffer.remaining()) ** GOTO lbl10
            clientBuffer.put(this.inAppData);
            break block1;
lbl-1000:
            // 1 sources

            {
                clientBuffer.put(this.inAppData.get());
lbl10:
                // 2 sources

                ** while (clientBuffer.hasRemaining())
            }
        }
        posAfter = this.inAppData.position();
        this.inAppData.compact();
        return posAfter - posBefore;
    }
}

