/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.wst.xquery.marklogic.xcc.Content;
import org.eclipse.wst.xquery.marklogic.xcc.ContentCreateOptions;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ContentFactory {
    private static TransformerFactory transformerFactory = null;

    private ContentFactory() {
    }

    public static Content newContent(String uri, Document document, ContentCreateOptions createOptions) {
        return ContentFactory.newContent(uri, ContentFactory.bytesFromW3cDoc(document), createOptions == null ? ContentCreateOptions.newXmlInstance() : createOptions);
    }

    public static Content newContent(String uri, Node documentNode, ContentCreateOptions createOptions) {
        return ContentFactory.newContent(uri, ContentFactory.bytesFromW3cNode(documentNode), createOptions == null ? ContentCreateOptions.newXmlInstance() : createOptions);
    }

    public static Content newContent(String uri, XdmNode documentNode, ContentCreateOptions createOptions) {
        return ContentFactory.newContent(uri, ContentFactory.bytesFromString(documentNode.asString()), createOptions == null ? ContentCreateOptions.newXmlInstance() : createOptions);
    }

    public static Content newContent(String uri, File documentFile, ContentCreateOptions createOptions) {
        return new FileContent(uri, documentFile, createOptions);
    }

    public static Content newContent(String uri, RandomAccessFile documentFile, ContentCreateOptions createOptions) throws IOException {
        return new RandomAccessFileContent(uri, documentFile, createOptions);
    }

    public static Content newUnBufferedContent(String uri, URL documentUrl, ContentCreateOptions createOptions) throws IOException {
        return new InputStreamContent(uri, documentUrl.openStream(), createOptions);
    }

    public static Content newUnBufferedContent(String uri, URI documentUri, ContentCreateOptions createOptions) throws IOException {
        return ContentFactory.newUnBufferedContent(uri, documentUri.toURL(), createOptions);
    }

    public static Content newContent(String uri, URL documentUrl, ContentCreateOptions createOptions) throws IOException {
        return new ByteArrayContent(uri, ContentFactory.bytesFromStream(documentUrl.openStream()), createOptions);
    }

    public static Content newContent(String uri, URI documentUri, ContentCreateOptions createOptions) throws IOException {
        return ContentFactory.newContent(uri, documentUri.toURL(), createOptions);
    }

    public static Content newContent(String uri, String documentString, ContentCreateOptions createOptions) {
        return ContentFactory.newContent(uri, ContentFactory.bytesFromString(documentString), createOptions);
    }

    public static Content newContent(String uri, byte[] documentBytes, ContentCreateOptions createOptions) {
        return new ByteArrayContent(uri, documentBytes, createOptions);
    }

    public static Content newContent(String uri, byte[] documentBytes, int offset, int length, ContentCreateOptions createOptions) {
        return new ByteArrayContent(uri, documentBytes, offset, length, createOptions);
    }

    public static Content newContent(String uri, InputStream documentStream, ContentCreateOptions createOptions) throws IOException {
        return new ByteArrayContent(uri, ContentFactory.bytesFromStream(documentStream), createOptions);
    }

    public static Content newUnBufferedContent(String uri, InputStream documentStream, ContentCreateOptions createOptions) {
        return new InputStreamContent(uri, documentStream, createOptions);
    }

    private static byte[] bytesFromString(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    private static byte[] bytesFromStream(InputStream is) throws IOException {
        int rc;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        while ((rc = is.read(buffer)) != -1) {
            os.write(buffer, 0, rc);
        }
        is.close();
        os.flush();
        buffer = os.toByteArray();
        os.close();
        return buffer;
    }

    private static synchronized TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    static byte[] bytesFromW3cNode(Node node) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult rslt = new StreamResult(bos);
        DOMSource src = new DOMSource(node);
        try {
            Transformer transformer = ContentFactory.getTransformerFactory().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(src, rslt);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Cannot serialize Node: " + e, e);
        }
        return bos.toByteArray();
    }

    static byte[] bytesFromW3cDoc(Document document) {
        return ContentFactory.bytesFromW3cNode(document.getDocumentElement());
    }

    private static class ByteArrayContent
    implements Content {
        private final String uri;
        private final byte[] bytes;
        private final int offset;
        private final int length;
        private final ContentCreateOptions options;

        public ByteArrayContent(String uri, byte[] bytes, int offset, int length, ContentCreateOptions options) {
            if (uri == null || uri.length() == 0) {
                throw new IllegalArgumentException("URI may not be null or zero-length");
            }
            this.uri = uri;
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
            this.options = options;
        }

        public ByteArrayContent(String uri, byte[] bytes, ContentCreateOptions options) {
            this(uri, bytes, 0, bytes.length, options);
        }

        public String getUri() {
            return this.uri;
        }

        public InputStream openDataStream() {
            return new ByteArrayInputStream(this.bytes, this.offset, this.length);
        }

        public ContentCreateOptions getCreateOptions() {
            return this.options;
        }

        public boolean isRewindable() {
            return true;
        }

        public void rewind() {
        }

        public long size() {
            return this.length;
        }

        public void close() {
        }
    }

    private static class FileContent
    implements Content {
        private final String uri;
        private final ContentCreateOptions options;
        private final File file;
        private InputStream activeStream;

        public FileContent(String uri, File file, ContentCreateOptions options) {
            if (uri == null || uri.length() == 0) {
                throw new IllegalArgumentException("URI may not be null or zero-length");
            }
            this.uri = uri;
            this.file = file;
            this.options = options;
        }

        public String getUri() {
            return this.uri;
        }

        public InputStream openDataStream() throws FileNotFoundException {
            this.activeStream = new BufferedInputStream(new FileInputStream(this.file));
            return this.activeStream;
        }

        public ContentCreateOptions getCreateOptions() {
            return this.options;
        }

        public boolean isRewindable() {
            return true;
        }

        public void rewind() throws IOException {
            this.close();
        }

        public long size() {
            return this.file.length();
        }

        public void close() {
            if (this.activeStream != null) {
                try {
                    this.activeStream.close();
                }
                catch (IOException iOException) {}
                this.activeStream = null;
            }
        }
    }

    private static class InputStreamContent
    implements Content {
        private final String uri;
        private final ContentCreateOptions options;
        private InputStream is;

        public InputStreamContent(String uri, InputStream is, ContentCreateOptions options) {
            this.uri = uri;
            this.is = is;
            this.options = options;
        }

        public String getUri() {
            return this.uri;
        }

        public InputStream openDataStream() throws FileNotFoundException {
            if (this.is == null) {
                throw new IllegalStateException("Data stream has already been consumed");
            }
            InputStream isTmp = this.is;
            this.is = null;
            return isTmp;
        }

        public ContentCreateOptions getCreateOptions() {
            return this.options;
        }

        public boolean isRewindable() {
            return this.is != null;
        }

        public void rewind() throws IOException {
            if (this.is == null) {
                throw new IllegalStateException("This Content is not rewindable");
            }
        }

        public long size() {
            return -1L;
        }

        public void close() {
            this.is = null;
        }
    }

    private static class RandomAccessFileContent
    implements Content {
        private final String uri;
        private final ContentCreateOptions options;
        private final RandomAccessFile raFile;
        private final long start;

        public RandomAccessFileContent(String uri, RandomAccessFile raFile, ContentCreateOptions options) throws IOException {
            if (uri == null || uri.length() == 0) {
                throw new IllegalArgumentException("URI may not be null or zero-length");
            }
            this.uri = uri;
            this.raFile = raFile;
            this.options = options;
            this.start = raFile.getFilePointer();
        }

        public String getUri() {
            return this.uri;
        }

        public InputStream openDataStream() throws IOException {
            this.raFile.seek(this.start);
            return Channels.newInputStream(this.raFile.getChannel());
        }

        public ContentCreateOptions getCreateOptions() {
            return this.options;
        }

        public boolean isRewindable() {
            return true;
        }

        public void rewind() throws IOException {
            this.raFile.seek(this.start);
        }

        public long size() {
            try {
                return this.raFile.length() - this.start;
            }
            catch (IOException iOException) {
                return -1L;
            }
        }

        public void close() {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {}
        }
    }
}

